/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.freeplane.view.swing.map.outline.OutlineGeometry;
import org.freeplane.view.swing.map.outline.OutlineVisibleBlockRange;
import org.freeplane.view.swing.map.outline.VisibleOutlineNodes;

class OutlineViewport {
    private final JScrollPane scrollPane;
    private final VisibleOutlineNodes visibleState;
    private final int blockSize;

    OutlineViewport(JScrollPane scrollPane, VisibleOutlineNodes visibleState, int blockSize) {
        this.scrollPane = scrollPane;
        this.visibleState = visibleState;
        this.blockSize = blockSize;
    }

    private void setViewPosition(Point position) {
        this.scrollPane.getViewport().setViewPosition(position);
    }

    void setViewPosition(int startFromNodeIndex, int blockBreadcrumbOverlap) {
        OutlineGeometry instance = OutlineGeometry.getInstance();
        int rowHeight = instance.rowHeight;
        int targetY = startFromNodeIndex * rowHeight - blockBreadcrumbOverlap;
        targetY = Math.max(0, targetY);
        Point viewPosition = new Point(-this.scrollPane.getViewport().getView().getX(), targetY);
        this.setViewPosition(viewPosition);
    }

    int getViewportHeight() {
        int viewportHeight = this.scrollPane.getViewport().getHeight();
        return viewportHeight;
    }

    int getViewY() {
        int viewY = -this.scrollPane.getViewport().getView().getY();
        return viewY;
    }

    int getViewportWidth() {
        return this.scrollPane.getViewport().getWidth();
    }

    void refreshViewport() {
        Component view = this.scrollPane.getViewport().getView();
        if (view instanceof JComponent) {
            ((JComponent)view).revalidate();
        }
        this.scrollPane.getViewport().revalidate();
        this.scrollPane.repaint();
    }

    OutlineVisibleBlockRange calculateVisibleBlockRange() {
        OutlineGeometry geometry = OutlineGeometry.getInstance();
        int blockHeight = this.blockSize * geometry.rowHeight;
        int visibleNodeCount = this.visibleState.getVisibleNodeCount();
        int totalBlocks = (visibleNodeCount + this.blockSize - 1) / this.blockSize;
        int breadcrumbHeight = this.visibleState.getBreadcrumbHeight();
        int blockPanelY = this.visibleState.getBlockPanelY();
        int adjustedViewY = Math.max(0, this.getViewY() - (breadcrumbHeight - blockPanelY));
        int adjustedViewHeight = this.getViewportHeight();
        int firstBlock = Math.max(0, adjustedViewY / blockHeight);
        int lastBlock = Math.min(totalBlocks - 1, (adjustedViewY + adjustedViewHeight) / blockHeight);
        int viewportWidth = this.getViewportWidth();
        return new OutlineVisibleBlockRange(firstBlock, lastBlock, breadcrumbHeight, viewportWidth, visibleNodeCount);
    }
}

