/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.resizer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class JResizer
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final int CONTROL_SIZE = 5;
    protected boolean sliderLock = false;
    private Point point;
    protected final Direction direction;
    protected final Box parentBox;
    protected final Component resizedComponent;

    JResizer(final Direction direction, final Component resizedComponent) {
        int h;
        int w;
        this.direction = direction;
        this.resizedComponent = resizedComponent;
        Box resizerBox = direction.createBox();
        switch (direction.ordinal()) {
            case 0: 
            case 3: {
                resizerBox.add(this);
                resizerBox.add(resizedComponent);
                break;
            }
            default: {
                resizerBox.add(resizedComponent);
                resizerBox.add(this);
            }
        }
        this.parentBox = resizerBox;
        this.setOpaque(true);
        if (direction.equals((Object)Direction.RIGHT)) {
            w = 5;
            h = 0;
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else if (direction.equals((Object)Direction.LEFT)) {
            h = 5;
            w = 0;
            this.setCursor(Cursor.getPredefinedCursor(10));
        } else if (direction.equals((Object)Direction.UP)) {
            h = 0;
            w = 5;
            this.setCursor(Cursor.getPredefinedCursor(8));
        } else {
            h = 0;
            w = 5;
            this.setCursor(Cursor.getPredefinedCursor(9));
        }
        this.setPreferredSize(new Dimension(w, h));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JResizer.this.point = null;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JResizer.this.point = null;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (JResizer.this.sliderLock) {
                    return;
                }
                Point point2 = e.getPoint();
                SwingUtilities.convertPointToScreen(point2, e.getComponent());
                if (JResizer.this.point != null && resizedComponent.isVisible()) {
                    JRootPane rootPane = JResizer.this.getRootPane();
                    Dimension size = new Dimension(resizedComponent.getPreferredSize());
                    if (direction.equals((Object)Direction.RIGHT)) {
                        size.width -= point2.x - ((JResizer)JResizer.this).point.x;
                    } else if (direction.equals((Object)Direction.LEFT)) {
                        size.width += point2.x - ((JResizer)JResizer.this).point.x;
                    } else if (direction.equals((Object)Direction.UP)) {
                        size.height += point2.y - ((JResizer)JResizer.this).point.y;
                    } else if (direction.equals((Object)Direction.DOWN)) {
                        size.height -= point2.y - ((JResizer)JResizer.this).point.y;
                    }
                    size.width = Math.min(size.width, rootPane.getWidth() * 9 / 10 - 5);
                    size.height = Math.min(size.height, rootPane.getHeight() * 9 / 10 - 5);
                    resizedComponent.setPreferredSize(new Dimension(Math.max(size.width, 0), Math.max(size.height, 0)));
                    JResizer.this.parentBox.revalidate();
                    JResizer.this.parentBox.repaint();
                }
                JResizer.this.point = point2;
            }
        });
    }

    public void setSliderLocked(boolean enabled) {
        this.sliderLock = enabled;
    }

    public boolean isSliderLocked() {
        return this.sliderLock;
    }

    public static enum Direction {
        RIGHT,
        LEFT,
        UP,
        DOWN;


        private Box createBox() {
            switch (this.ordinal()) {
                case 0: 
                case 1: {
                    return Box.createHorizontalBox();
                }
            }
            return Box.createVerticalBox();
        }

        int getPreferredSize(Component component) {
            Dimension preferredSize = component.getPreferredSize();
            switch (this.ordinal()) {
                case 0: 
                case 1: {
                    return preferredSize.width;
                }
            }
            return preferredSize.height;
        }

        void setPreferredSize(Component component, int size) {
            if (size >= 0) {
                switch (this.ordinal()) {
                    case 0: 
                    case 1: {
                        component.setPreferredSize(new Dimension(size, 1));
                        return;
                    }
                }
                component.setPreferredSize(new Dimension(1, size));
            } else {
                component.setPreferredSize(null);
            }
        }
    }
}

