/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IDocumentDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferUtils;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterSourceCode
extends StreamExporterAbstract
implements IDocumentDataExporter {
    private static final String PROP_FORMAT_DATE_ISO = "formatDateISOPHP";
    private static final String PROP_LANGUAGE = "language";
    private static final String PROP_QUOTE_CHAR = "quoteChar";
    private static final String PROP_ROW_DELIMITER = "rowDelimiter";
    private static final String ROW_DELIMITER_DEFAULT = "default";
    private static final String DEF_QUOTE_CHAR = "\"";
    private DBDAttributeBinding[] columns;
    private int rowNum = 0;
    private boolean formatDateISO = true;
    private ProgramLanguages language;
    private String rowDelimiter;
    private char quoteChar = (char)34;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        Object quoteProp;
        super.init(site);
        Map<String, Object> properties = site.getProperties();
        this.formatDateISO = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_FORMAT_DATE_ISO), (boolean)true);
        this.language = ProgramLanguages.fromValue(CommonUtils.toString((Object)properties.get(PROP_LANGUAGE)));
        this.rowDelimiter = StreamTransferUtils.getDelimiterString(properties, PROP_ROW_DELIMITER);
        if (ROW_DELIMITER_DEFAULT.equalsIgnoreCase(this.rowDelimiter.trim())) {
            this.rowDelimiter = GeneralUtils.getDefaultLineSeparator();
        }
        if (!(quoteProp = properties.get(PROP_QUOTE_CHAR)).equals(DEF_QUOTE_CHAR)) {
            this.quoteChar = (char)39;
        }
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        String tableName = this.getSite().getSource().getName();
        PrintWriter out = this.getWriter();
        out.write("<?php" + this.rowDelimiter);
        out.write("$" + tableName + " = ");
        if (this.language == ProgramLanguages.PHP_VERSION_LESS_5_and_4) {
            out.write("array(" + this.rowDelimiter);
        } else {
            out.write("[" + this.rowDelimiter);
        }
        this.rowNum = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        out = this.getWriter();
        if (this.rowNum > 0) {
            out.write("," + this.rowDelimiter);
        }
        ++this.rowNum;
        if (this.language == ProgramLanguages.PHP_VERSION_LESS_5_and_4) {
            out.write("\tarray(" + this.rowDelimiter);
        } else {
            out.write("\t[" + this.rowDelimiter);
        }
        for (i = 0; i < this.columns.length; ++i) {
            column = this.columns[i];
            columnName = column.getLabel();
            if (CommonUtils.isEmpty((String)columnName)) {
                columnName = column.getName();
            }
            out.write("\t\t" + this.quoteChar + JSONUtils.escapeJsonString((String)columnName) + this.quoteChar + " => ");
            cellValue = row[i];
            if (DBUtils.isNullValue((Object)cellValue)) {
                this.writeTextCell(null);
            } else if (cellValue instanceof DBDContent) {
                content = (DBDContent)cellValue;
                try {
                    cs = content.getContents(session.getProgressMonitor());
                    if (cs == null) ** GOTO lbl47
                    if (ContentUtils.isTextContent((DBDContent)content)) {
                        in = cs.getContentReader();
                        try {
                            out.write(this.quoteChar);
                            this.writeCellValue(in);
                            out.write(this.quoteChar);
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    this.getSite().writeBinaryData(cs);
                }
                finally {
                    DTUtils.closeContents(resultSet, content);
                }
            } else if (cellValue instanceof Number || cellValue instanceof Boolean) {
                out.write(cellValue.toString());
            } else if (cellValue instanceof Date && this.formatDateISO) {
                this.writeTextCell(JSONUtils.formatDate((Date)((Date)cellValue)));
            } else {
                this.writeTextCell(super.getValueDisplayString(column, cellValue));
            }
lbl47:
            // 7 sources

            if (i < this.columns.length - 1) {
                out.write(",");
            }
            out.write(this.rowDelimiter);
        }
        if (this.language == ProgramLanguages.PHP_VERSION_LESS_5_and_4) {
            out.write("\t)");
        } else {
            out.write("\t]");
        }
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) throws DBException, IOException {
        PrintWriter out = this.getWriter();
        if (this.language == ProgramLanguages.PHP_VERSION_LESS_5_and_4) {
            out.write(this.rowDelimiter + ");");
        } else {
            out.write(this.rowDelimiter + "];");
        }
        out.write(this.rowDelimiter + "?>");
    }

    private void writeTextCell(@Nullable String value) {
        if (value != null) {
            this.getWriter().write(this.quoteChar + JSONUtils.escapeJsonString((String)value) + this.quoteChar);
        } else {
            this.getWriter().write("null");
        }
    }

    private void writeCellValue(Reader reader) throws IOException {
        int count;
        char[] buffer = new char[2000];
        while ((count = reader.read(buffer)) > 0) {
            this.getWriter().write(JSONUtils.escapeJsonString((String)new String(buffer, 0, count)));
        }
    }

    static enum ProgramLanguages {
        PHP_VERSION_LESS_5_and_4("PHP < 5.4"),
        PHP_VERSION_AT_LEAST_5_AND_4("PHP 5.4+");

        private final String value;

        private ProgramLanguages(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static ProgramLanguages fromValue(String v) {
            for (ProgramLanguages s : ProgramLanguages.values()) {
                if (!s.value.equals(v)) continue;
                return s;
            }
            return PHP_VERSION_LESS_5_and_4;
        }
    }
}

