/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferAttributeTransformer;

public class DataTransferAttributeTransformerDescriptor
extends AbstractDescriptor {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    private final String description;
    @NotNull
    private final DBPImage icon;
    private final AbstractDescriptor.ObjectType implType;
    private final List<DBPPropertyDescriptor> properties = new ArrayList<DBPPropertyDescriptor>();

    public DataTransferAttributeTransformerDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"), (DBPImage)DBIcon.TYPE_UNKNOWN);
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        for (IConfigurationElement prop : config.getChildren("propertyGroup")) {
            this.properties.addAll(PropertyDescriptor.extractProperties((IConfigurationElement)prop));
        }
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public DBPImage getIcon() {
        return this.icon;
    }

    @NotNull
    public List<DBPPropertyDescriptor> getProperties() {
        return this.properties;
    }

    public IDataTransferAttributeTransformer createTransformer() throws DBException {
        try {
            return (IDataTransferAttributeTransformer)this.implType.getImplClass(IDataTransferAttributeTransformer.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new DBException("Can't create attribute transformer instance", e);
        }
    }

    public String toString() {
        return this.id;
    }
}

