/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model.session;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.session.MySQLSession;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManagerSQL;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.utils.CommonUtils;

public class MySQLSessionManager
implements DBAServerSessionManager<MySQLSession>,
DBAServerSessionManagerSQL {
    public static final String PROP_KILL_QUERY = "killQuery";
    public static final String OPTION_HIDE_SLEEPING = "hideSleeping";
    public static final String OPTION_SHOW_PERFORMANCE = "showPerformance";
    private final MySQLDataSource dataSource;

    public MySQLSessionManager(MySQLDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Collection<MySQLSession> getSessions(@NotNull DBCSession session, @NotNull Map<String, Object> options) throws DBException {
        boolean hideSleeping = CommonUtils.getOption(options, (String)OPTION_HIDE_SLEEPING);
        try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(this.generateSessionReadQuery(options));){
            ArrayList<MySQLSession> arrayList;
            block15: {
                JDBCResultSet dbResult = dbStat.executeQuery();
                try {
                    ArrayList<MySQLSession> sessions = new ArrayList<MySQLSession>();
                    while (dbResult.next()) {
                        MySQLSession sessionInfo = new MySQLSession((ResultSet)dbResult, options);
                        if (hideSleeping && "Sleep".equals(sessionInfo.getCommand())) continue;
                        sessions.add(sessionInfo);
                    }
                    arrayList = sessions;
                    if (dbResult == null) break block15;
                }
                catch (Throwable throwable) {
                    if (dbResult != null) {
                        try {
                            dbResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dbResult.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(@NotNull DBCSession session, @NotNull String sessionId, @NotNull Map<String, Object> options) throws DBException {
        try {
            String sqlCommand = Boolean.TRUE.equals(options.get(PROP_KILL_QUERY)) ? "KILL QUERY ?" : "KILL CONNECTION ?";
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(sqlCommand);){
                dbStat.setString(1, sessionId);
                dbStat.execute();
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    @NotNull
    public Map<String, Object> getTerminateOptions() {
        return Map.of();
    }

    public boolean canGenerateSessionReadQuery() {
        return true;
    }

    @NotNull
    public String generateSessionReadQuery(@NotNull Map<String, Object> options) {
        if (this.dataSource.supportsSysSchema() && CommonUtils.toBoolean((Object)options.get(OPTION_SHOW_PERFORMANCE))) {
            return "SELECT\n\tip.*,\n\tsp.statement_latency,\n\tsp.progress,\n\tsp.lock_latency,\n\tsp.rows_examined,\n\tsp.rows_sent,\n\tsp.rows_affected,\n\tsp.tmp_tables,\n\tsp.tmp_disk_tables,\n\tsp.full_scan,\n\tsp.last_statement,\n\tsp.last_statement_latency,\n\tsp.current_memory,\n\tsp.source,\n\tsp.trx_latency,\n\tsp.trx_state,\n\tsp.trx_autocommit,\n\tsp.program_name\nFROM information_schema.PROCESSLIST ip\nLEFT JOIN sys.processlist sp ON\n\tsp.CONN_ID = ip.ID";
        }
        return "SHOW FULL PROCESSLIST";
    }
}

