/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.update;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.impl.app.ApplicationDescriptor;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.internal.CoreApplicationActivator;
import org.jkiss.dbeaver.ui.app.standalone.update.CheckForUpdateAction;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class VersionUpdateDialog
extends Dialog {
    private static final Log log = Log.getLog(VersionUpdateDialog.class);
    private static final String PROP_DISTRIBUTION_TYPE = "dbeaver.distribution.type";
    private static final String OS_WINDOWS = "win";
    private static final String OS_MACOS = "mac";
    private static final String OS_LINUX = "linux";
    private static final String DISTRIBUTION_DEB = "deb";
    private static final String DISTRIBUTION_RPM = "rpm";
    private static final int INFO_ID = 1000;
    private static final int UPGRADE_ID = 1001;
    private static final int CHECK_EA_ID = 1002;
    private final Version currentVersion;
    private final VersionDescriptor newVersion;
    private Font boldFont;
    private boolean showConfig;
    private Button dontShowAgainCheck;
    private final String earlyAccessURL;

    public VersionUpdateDialog(Shell parentShell, @NotNull Version currentVersion, @NotNull VersionDescriptor newVersion, boolean showConfig) {
        super(parentShell);
        this.currentVersion = currentVersion;
        this.newVersion = newVersion;
        this.showConfig = showConfig;
        this.earlyAccessURL = GeneralUtils.getProductEarlyAccessURL();
    }

    @NotNull
    public VersionDescriptor getNewVersion() {
        return this.newVersion;
    }

    public boolean isShowConfig() {
        return this.showConfig;
    }

    public Font getBoldFont() {
        return this.boldFont;
    }

    protected boolean isResizable() {
        return true;
    }

    private boolean isNewVersionAvailable() {
        return this.newVersion.getProgramVersion().compareTo(this.currentVersion) > 0;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CoreMessages.dialog_version_update_title);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite propGroup = UIUtils.createTitledComposite((Composite)composite, (String)CoreMessages.dialog_version_update_title, (int)2, (int)1808);
        this.createTopArea(composite);
        this.boldFont = UIUtils.makeBoldFont((Font)composite.getFont());
        Label titleLabel = new Label(propGroup, 0);
        titleLabel.setText(NLS.bind((String)(!this.isNewVersionAvailable() ? CoreMessages.dialog_version_update_no_new_version : CoreMessages.dialog_version_update_available_new_version), (Object)GeneralUtils.getProductName()));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        titleLabel.setLayoutData((Object)gd);
        titleLabel.setFont(this.boldFont);
        UIUtils.createControlLabel((Composite)propGroup, (String)CoreMessages.dialog_version_update_current_version);
        new Label(propGroup, 0).setText(this.currentVersion.toString());
        UIUtils.createControlLabel((Composite)propGroup, (String)CoreMessages.dialog_version_update_new_version);
        new Label(propGroup, 0).setText(this.newVersion.getProgramVersion().toString() + "    (" + this.newVersion.getUpdateTime() + ")");
        if (this.isNewVersionAvailable()) {
            Label notesLabel = UIUtils.createControlLabel((Composite)propGroup, (String)CoreMessages.dialog_version_update_notes);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            notesLabel.setLayoutData((Object)gd);
            Text notesText = new Text(propGroup, 584);
            String releaseNotes = CommonUtils.notEmpty((String)this.newVersion.getReleaseNotes());
            if (releaseNotes.isEmpty()) {
                releaseNotes = CoreMessages.dialog_version_update_no_notes;
            }
            releaseNotes = VersionUpdateDialog.formatReleaseNotes(releaseNotes);
            notesText.setText(releaseNotes);
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            gd.heightHint = CommonUtils.clamp((int)notesText.getLineCount(), (int)5, (int)20) * notesText.getLineHeight();
            notesText.setLayoutData((Object)gd);
            Label hintLabel = new Label(propGroup, 0);
            hintLabel.setText(NLS.bind((String)CoreMessages.dialog_version_update_press_more_info, (Object)CoreMessages.dialog_version_update_button_more_info, (Object)this.newVersion.getPlainVersion()));
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            hintLabel.setLayoutData((Object)gd);
            hintLabel.setFont(this.boldFont);
        }
        this.createBottomArea(composite);
        return parent;
    }

    private static String formatReleaseNotes(String releaseNotes) {
        while (releaseNotes.startsWith("\n")) {
            releaseNotes = releaseNotes.substring(1);
        }
        String[] rnLines = releaseNotes.split("\n");
        int leadSpacesNum = 0;
        for (int i = 0; i < rnLines[0].length() && rnLines[0].charAt(i) == ' '; ++i) {
            ++leadSpacesNum;
        }
        StringBuilder result = new StringBuilder();
        for (String rnLine : rnLines) {
            if (rnLine.length() <= leadSpacesNum) continue;
            if (result.length() > 0) {
                result.append("\n");
            }
            result.append(rnLine.substring(leadSpacesNum));
        }
        return result.toString();
    }

    protected void createTopArea(Composite composite) {
    }

    protected void createBottomArea(Composite composite) {
    }

    public boolean close() {
        this.boldFont.dispose();
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.showConfig && this.isNewVersionAvailable()) {
            ++((GridLayout)parent.getLayout()).numColumns;
            this.dontShowAgainCheck = UIUtils.createCheckbox((Composite)parent, (String)NLS.bind((String)CoreMessages.dialog_version_update_ignore_version, (Object)this.newVersion.getPlainVersion()), (boolean)false);
        }
        if (this.isNewVersionAvailable()) {
            this.createButton(parent, 1001, CoreMessages.dialog_version_update_button_upgrade, true);
        } else if (!CommonUtils.isEmpty((String)this.earlyAccessURL)) {
            this.createButton(parent, 1002, CoreMessages.dialog_version_update_button_early_access, false);
        }
        this.createButton(parent, 1000, CoreMessages.dialog_version_update_button_more_info, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, !this.isNewVersionAvailable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buttonPressed(int buttonId) {
        if (this.dontShowAgainCheck != null && this.dontShowAgainCheck.getSelection()) {
            CoreApplicationActivator.getDefault().getPreferenceStore().setValue("suppressUpdateCheck." + this.newVersion.getPlainVersion(), true);
        }
        if (buttonId == 1000) {
            ShellUtils.launchProgram((String)this.newVersion.getBaseURL());
        } else if (buttonId == 1001) {
            final PlatformInstaller installer = this.getPlatformInstaller();
            if (installer != null) {
                AbstractJob job = new AbstractJob(this, "Downloading installation file"){
                    final /* synthetic */ VersionUpdateDialog this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @NotNull
                    protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                        Path file;
                        Path folder;
                        ApplicationDescriptor app = ApplicationRegistry.getInstance().getApplication();
                        try {
                            String executable = installer.getExecutableName(app);
                            folder = Files.createTempDirectory(executable, new FileAttribute[0]);
                            file = Files.createFile(folder.resolve(executable), new FileAttribute[0]);
                            log.debug((Object)("Downloading installation file to " + String.valueOf(file)));
                            WebUtils.downloadRemoteFile((DBRProgressMonitor)monitor, (String)"Obtaining installer", (String)this.this$0.getDownloadURL(app, installer, this.this$0.newVersion), (Path)file, null);
                        }
                        catch (IOException e) {
                            return GeneralUtils.makeErrorStatus((String)CoreMessages.dialog_version_update_downloader_error_cannot_download, (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            log.debug((Object)"Canceled by user", (Throwable)e);
                            return Status.OK_STATUS;
                        }
                        if (UIUtils.confirmAction((String)CoreMessages.dialog_version_update_downloader_title, (String)NLS.bind((String)CoreMessages.dialog_version_update_downloader_confirm_install, (Object)app.getName()))) {
                            final IWorkbench workbench = PlatformUI.getWorkbench();
                            IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
                            IWorkbenchListener listener = new IWorkbenchListener(){
                                {
                                    workbench.addWorkbenchListener((IWorkbenchListener)this);
                                }

                                public boolean preShutdown(IWorkbench workbench2, boolean forced) {
                                    return true;
                                }

                                public void postShutdown(IWorkbench workbench2) {
                                    try {
                                        installer.run(file, log);
                                    }
                                    catch (Exception e) {
                                        log.error((Object)"Failed to run the installer script", (Throwable)e);
                                    }
                                }
                            };
                            UIUtils.asyncExec(() -> {
                                ActionUtils.runCommand((String)"org.eclipse.ui.file.exit", (IServiceLocator)workbenchWindow);
                                if (!workbench.isClosing()) {
                                    workbench.removeWorkbenchListener(listener);
                                    ShellUtils.launchProgram((String)folder.toString());
                                }
                            });
                        } else {
                            ShellUtils.showInSystemExplorer((String)file.toAbsolutePath().toString());
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            } else {
                ShellUtils.launchProgram((String)this.getDownloadPageURL(this.newVersion));
            }
        } else if (buttonId == 1002) {
            if (!CommonUtils.isEmpty((String)this.earlyAccessURL)) {
                ShellUtils.launchProgram((String)this.earlyAccessURL);
            }
        } else if (buttonId == 10) {
            IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
            CheckForUpdateAction.activateStandardHandler(window);
            try {
                ActionUtils.runCommand((String)"org.eclipse.equinox.p2.ui.sdk.update", (IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            finally {
                CheckForUpdateAction.deactivateStandardHandler(window);
            }
        }
        this.close();
    }

    @Nullable
    private PlatformInstaller getPlatformInstaller() {
        return switch (Platform.getOS()) {
            case "win32" -> new WindowsInstaller();
            case "macosx" -> new MacintoshInstaller();
            default -> null;
        };
    }

    @NotNull
    private String getDownloadURL(@NotNull ApplicationDescriptor application, @NotNull PlatformInstaller installer, @NotNull VersionDescriptor version) {
        String executable = installer.getExecutableName(application);
        return CommonUtils.removeTrailingSlash((String)version.getDownloadURL()) + "/" + executable;
    }

    @NotNull
    private String getDownloadPageURL(@NotNull VersionDescriptor version) {
        String os = RuntimeUtils.isWindows() ? OS_WINDOWS : (RuntimeUtils.isMacOS() ? OS_MACOS : OS_LINUX);
        String dist = System.getProperty(PROP_DISTRIBUTION_TYPE);
        if (CommonUtils.isEmpty((String)dist) && RuntimeUtils.isLinux()) {
            try {
                RuntimeUtils.executeProcess((String)"/usr/bin/apt-get", (String[])new String[]{"--version"});
                dist = DISTRIBUTION_DEB;
            }
            catch (DBException e) {
                dist = DISTRIBUTION_RPM;
            }
        }
        return CommonUtils.removeTrailingSlash((String)version.getBaseURL()) + "?start&os=" + os + "&arch=" + Platform.getOSArch() + (String)(dist == null ? "" : "&dist=" + dist);
    }

    private static interface PlatformInstaller {
        public void run(@NotNull Path var1, @NotNull Log var2) throws Exception;

        @NotNull
        public String getExecutableName(@NotNull ApplicationDescriptor var1);
    }

    private static final class WindowsInstaller
    implements PlatformInstaller {
        private WindowsInstaller() {
        }

        @Override
        public void run(@NotNull Path executable, @NotNull Log log) throws Exception {
            String path = executable.toString();
            Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", "start", "/W", path, "&&", "del", path});
        }

        @Override
        @NotNull
        public String getExecutableName(@NotNull ApplicationDescriptor application) {
            if ("zip".equals(System.getProperty(VersionUpdateDialog.PROP_DISTRIBUTION_TYPE))) {
                return application.getId() + "-latest-win32.win32." + Platform.getOSArch() + ".zip";
            }
            return application.getId() + "-latest-" + Platform.getOSArch() + "-setup.exe";
        }
    }

    private static final class MacintoshInstaller
    implements PlatformInstaller {
        private MacintoshInstaller() {
        }

        @Override
        public void run(@NotNull Path executable, @NotNull Log log) throws Exception {
            String path = CommonUtils.escapeBourneShellString((String)executable.toString());
            Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "open -F -W " + path + " && rm " + path});
        }

        @Override
        @NotNull
        public String getExecutableName(@NotNull ApplicationDescriptor application) {
            return application.getId() + "-latest-macos-" + Platform.getOSArch() + ".dmg";
        }
    }
}

