/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.pages.database.PreviewConsumer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseProgressDialog;
import org.jkiss.utils.CommonUtils;

class PreviewMappingDialog
extends BaseProgressDialog {
    private static final int previewRowCount = 100;
    private static final String DIALOG_ID = "DBeaver.DataTransfer.PreviewMappingDialog";
    private final DataTransferPipe pipe;
    private final DatabaseMappingContainer mappingContainer;
    private final DataTransferSettings dtSettings;
    private Table previewTable;

    PreviewMappingDialog(Shell parentShell, DataTransferPipe pipe, DatabaseMappingContainer mappingContainer, DataTransferSettings dtSettings) {
        super(parentShell, DTMessages.data_transfer_wizard_page_preview_title + " - " + mappingContainer.getTargetName(), null);
        this.pipe = pipe;
        this.mappingContainer = mappingContainer;
        this.dtSettings = dtSettings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite main = super.createDialogArea(parent);
        main.setLayoutData((Object)new GridData(1808));
        Composite previewGroup = new Composite(main, 0);
        previewGroup.setLayoutData((Object)new GridData(1808));
        previewGroup.setLayout((Layout)new GridLayout(1, false));
        UIUtils.createControlLabel((Composite)previewGroup, (String)DTMessages.data_transfer_wizard_settings_group_preview);
        this.previewTable = new Table(previewGroup, 67588);
        GridData gd = new GridData(1808);
        gd.widthHint = 600;
        gd.heightHint = 400;
        this.previewTable.setLayoutData((Object)gd);
        this.previewTable.setHeaderVisible(true);
        this.previewTable.setLinesVisible(true);
        UIUtils.asyncExec(this::loadTransferPreview);
        return main;
    }

    private void loadTransferPreview() {
        Throwable error = null;
        try {
            this.run(true, true, monitor -> {
                monitor.beginTask("Load preview", 1);
                try {
                    monitor.subTask("Process sample rows");
                    this.loadImportPreview(monitor);
                    monitor.worked(1);
                    monitor.done();
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            error = e.getTargetException();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Throwable finalError = error;
        if (finalError != null) {
            DBWorkbench.getPlatformUI().showError(DTUIMessages.stream_producer_page_preview_title_load_entity_meta, DTUIMessages.stream_producer_page_preview_message_entity_attributes, finalError);
        }
        UIUtils.asyncExec(() -> this.getShell().setFocus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImportPreview(DBRProgressMonitor monitor) throws DBException {
        PreviewConsumer previewConsumer = new PreviewConsumer(monitor, this.mappingContainer, 100);
        IDataTransferProducer producer = this.pipe.getProducer();
        IDataTransferSettings producerSettings = this.dtSettings.getNodeSettings((IDataTransferNode)producer);
        IDataTransferSettings consumerSettings = this.dtSettings.getNodeSettings((IDataTransferNode)this.pipe.getConsumer());
        try {
            IDataTransferConsumer realConsumer = this.pipe.getConsumer();
            try {
                this.pipe.setConsumer((IDataTransferConsumer)previewConsumer);
                this.pipe.initPipe(this.dtSettings, 0, 1);
                producer.transferData(previewConsumer.getCtlMonitor(), (IDataTransferConsumer)previewConsumer, this.dtSettings.getProcessor() == null ? null : this.dtSettings.getProcessor().getInstance(), producerSettings, null);
            }
            finally {
                this.pipe.setConsumer(realConsumer);
            }
        }
        finally {
            previewConsumer.close();
        }
        List<Object[]> rows = previewConsumer.getRows();
        ArrayList<String[]> strRows = new ArrayList<String[]>(rows.size());
        DBSDataManipulator target = this.mappingContainer.getTarget();
        if (target == null && consumerSettings instanceof DatabaseConsumerSettings) {
            target = ((DatabaseConsumerSettings)consumerSettings).getContainer();
        }
        if (target == null) {
            throw new DBException("Can not determine target container");
        }
        try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)target, (String)"Generate preview values");){
            DatabaseTransferConsumer.ColumnMapping[] columnMappings = previewConsumer.getColumnMappings();
            for (Object[] row : rows) {
                String[] strRow = new String[row.length];
                for (DatabaseTransferConsumer.ColumnMapping attr : columnMappings) {
                    if (attr == null) continue;
                    Object srcValue = row[attr.targetIndex];
                    Object value = attr.sourceValueHandler.getValueFromObject(session, (DBSTypedObject)attr.sourceAttr, srcValue, false, true);
                    DBSEntityAttribute attrTarget = attr.targetAttr.getTarget();
                    if (attrTarget == null) {
                        attrTarget = attr.sourceAttr;
                    }
                    String valueStr = attr.targetValueHandler.getValueDisplayString((DBSTypedObject)attrTarget, value, DBDDisplayFormat.UI);
                    strRow[attr.targetIndex] = CommonUtils.getSingleLineString((String)valueStr);
                }
                strRows.add(strRow);
            }
        }
        UIUtils.asyncExec(() -> {
            this.previewTable.setRedraw(false);
            try {
                this.previewTable.removeAll();
                for (TableColumn tableColumn : this.previewTable.getColumns()) {
                    tableColumn.dispose();
                }
                for (TableColumn tableColumn : previewConsumer.getColumnMappings()) {
                    if (tableColumn == null) continue;
                    TableColumn column = new TableColumn(this.previewTable, 0);
                    column.setText(tableColumn.targetAttr.getTargetName());
                    DBSEntityAttribute attr = tableColumn.targetAttr.getTarget();
                    if (attr == null) {
                        attr = tableColumn.sourceAttr;
                    }
                    column.setImage(DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)attr)));
                    column.setData((Object)tableColumn);
                }
                for (String[] row : strRows) {
                    void var6_12;
                    TableItem previewItem = new TableItem(this.previewTable, 0);
                    boolean bl = false;
                    while (var6_12 < row.length) {
                        if (row[var6_12] != null) {
                            previewItem.setText((int)var6_12, row[var6_12]);
                        }
                        ++var6_12;
                    }
                }
                UIUtils.packColumns((Table)this.previewTable);
            }
            finally {
                this.previewTable.setRedraw(true);
            }
        });
    }
}

