/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferAttributeTransformerDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.SharedTextColors;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.utils.CommonUtils;

class ColumnsMappingDialog
extends DialogPage {
    private final DatabaseConsumerSettings settings;
    private final DatabaseMappingContainer mapping;
    private final Collection<DatabaseMappingAttribute> attributeMappings;
    private TableViewer mappingViewer;

    ColumnsMappingDialog(DatabaseConsumerSettings settings, DatabaseMappingContainer mapping) {
        this.settings = settings;
        this.mapping = mapping;
        this.attributeMappings = mapping.getAttributeMappings();
    }

    public void createControl(Composite parent) {
        DBPDataSource targetDataSource = this.settings.getTargetDataSource((DatabaseMappingObject)this.mapping);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        DBPDataSource sourceDataSource = this.mapping.getSource().getDataSource();
        UIUtils.createLabelText((Composite)composite, (String)DTUIMessages.columns_mapping_dialog_composite_label_text_source_container, (String)(sourceDataSource == null ? "" : sourceDataSource.getContainer().getName()), (int)2056);
        Text sourceEntity = UIUtils.createLabelText((Composite)composite, (String)DTUIMessages.columns_mapping_dialog_composite_label_text_source_entity, (String)DBUtils.getObjectFullName((DBPNamedObject)this.mapping.getSource(), (DBPEvaluationContext)DBPEvaluationContext.UI), (int)2570);
        ((GridData)sourceEntity.getLayoutData()).widthHint = 600;
        ((GridData)sourceEntity.getLayoutData()).heightHint = UIUtils.getFontHeight((Control)sourceEntity) * 3;
        UIUtils.createLabelText((Composite)composite, (String)DTUIMessages.columns_mapping_dialog_composite_label_text_target_container, (String)(targetDataSource == null ? "?" : targetDataSource.getContainer().getName()), (int)2056);
        Text targetEntity = UIUtils.createLabelText((Composite)composite, (String)DTUIMessages.columns_mapping_dialog_composite_label_text_target_entity, (String)this.mapping.getTargetName(), (int)2056);
        ((GridData)targetEntity.getLayoutData()).widthHint = 600;
        ((GridData)targetEntity.getLayoutData()).heightHint = UIUtils.getFontHeight((Control)sourceEntity) * 3;
        this.mappingViewer = new TableViewer(composite, 67586);
        GridData gd = new GridData(1808);
        gd.widthHint = 600;
        gd.heightHint = 300;
        gd.horizontalSpan = 2;
        this.mappingViewer.getTable().setLayoutData((Object)gd);
        this.mappingViewer.getTable().setLinesVisible(true);
        this.mappingViewer.getTable().setHeaderVisible(true);
        this.mappingViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.mappingViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f') {
                    for (TableItem item : ColumnsMappingDialog.this.mappingViewer.getTable().getSelection()) {
                        DatabaseMappingAttribute attribute = (DatabaseMappingAttribute)item.getData();
                        attribute.setMappingType(DatabaseMappingType.skip);
                    }
                    ColumnsMappingDialog.this.mappingViewer.refresh();
                } else if (e.character == ' ') {
                    for (TableItem item : ColumnsMappingDialog.this.mappingViewer.getTable().getSelection()) {
                        DatabaseMappingAttribute attribute = (DatabaseMappingAttribute)item.getData();
                        attribute.setMappingType(DatabaseMappingType.existing);
                        try {
                            attribute.updateMappingType((DBRProgressMonitor)new VoidProgressMonitor(), false, false);
                        }
                        catch (DBException e1) {
                            DBWorkbench.getPlatformUI().showError("Bad mapping", "Invalid column mapping", (Throwable)e1);
                        }
                    }
                    ColumnsMappingDialog.this.mappingViewer.refresh();
                }
            }
        });
        ViewerColumnController columnController = new ViewerColumnController(((Object)((Object)this)).getClass().getName(), (ColumnViewer)this.mappingViewer);
        columnController.addColumn(DTUIMessages.columns_mapping_dialog_column_source_text, null, 16384, true, false, (CellLabelProvider)new ColumnLabelProvider(this){

            public void update(ViewerCell cell) {
                DatabaseMappingAttribute mapping = (DatabaseMappingAttribute)cell.getElement();
                cell.setText(DBUtils.getObjectFullName((DBPNamedObject)mapping.getSource(), (DBPEvaluationContext)DBPEvaluationContext.UI));
                if (mapping.getIcon() != null) {
                    cell.setImage(DBeaverIcons.getImage((DBPImage)mapping.getIcon()));
                }
            }
        });
        columnController.addColumn(DTUIMessages.columns_mapping_dialog_column_source_type_text, null, 16384, true, false, (CellLabelProvider)new ColumnLabelProvider(this){

            public void update(ViewerCell cell) {
                cell.setText(((DatabaseMappingAttribute)cell.getElement()).getSourceType());
            }
        });
        columnController.addColumn(DTUIMessages.columns_mapping_dialog_column_target_text, null, 16384, true, false, false, null, (CellLabelProvider)new ColumnLabelProvider(this){

            public void update(ViewerCell cell) {
                DatabaseMappingAttribute mapping = (DatabaseMappingAttribute)cell.getElement();
                cell.setText(mapping.getTargetName());
                if (mapping.getMappingType() == DatabaseMappingType.unspecified) {
                    cell.setBackground(UIUtils.getSharedTextColors().getColor(SharedTextColors.COLOR_WARNING));
                } else {
                    cell.setBackground(null);
                }
                cell.setFont(BaseThemeSettings.instance.treeAndTableFontBold);
            }
        }, new EditingSupport((ColumnViewer)this.mappingViewer){

            protected CellEditor getCellEditor(Object element) {
                try {
                    Object object;
                    ArrayList<String> items = new ArrayList<String>();
                    DatabaseMappingAttribute mapping = (DatabaseMappingAttribute)element;
                    DatabaseMappingContainer container = mapping.getParent();
                    if ((container.getMappingType() == DatabaseMappingType.existing || container.getMappingType() == DatabaseMappingType.recreate) && (object = container.getTarget()) instanceof DBSEntity) {
                        DBSEntity parentEntity = (DBSEntity)object;
                        for (DBSEntityAttribute attr : CommonUtils.safeCollection((Collection)parentEntity.getAttributes((DBRProgressMonitor)new VoidProgressMonitor()))) {
                            items.add(attr.getName());
                        }
                    }
                    items.add("[skip]");
                    return new CustomComboBoxCellEditor((ColumnViewer)ColumnsMappingDialog.this.mappingViewer, (Composite)ColumnsMappingDialog.this.mappingViewer.getTable(), items.toArray(new String[0]), 4);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Bad value", "Wrong target column", (Throwable)e);
                    return null;
                }
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((DatabaseMappingAttribute)element).getTargetName();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void setValue(Object element, Object value) {
                block9: {
                    try {
                        Object object;
                        String name = CommonUtils.toString((Object)value);
                        DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)element;
                        if ("[skip]".equals(name)) {
                            attrMapping.setMappingType(DatabaseMappingType.skip);
                            break block9;
                        }
                        DatabaseMappingContainer container = attrMapping.getParent();
                        if ((container.getMappingType() == DatabaseMappingType.existing || container.getMappingType() == DatabaseMappingType.recreate) && (object = container.getTarget()) instanceof DBSEntity) {
                            DBSEntity parentEntity = (DBSEntity)object;
                            for (DBSEntityAttribute attr : CommonUtils.safeCollection((Collection)parentEntity.getAttributes((DBRProgressMonitor)new VoidProgressMonitor()))) {
                                if (!name.equalsIgnoreCase(attr.getName())) continue;
                                attrMapping.setTarget(attr);
                                attrMapping.setMappingType(DatabaseMappingType.existing);
                                attrMapping.setTargetName(name);
                                return;
                            }
                        }
                        attrMapping.setMappingType(DatabaseMappingType.create);
                        attrMapping.setTargetName(name);
                    }
                    catch (DBException e) {
                        DBWorkbench.getPlatformUI().showError("Bad value", "Wrong target", (Throwable)e);
                    }
                    finally {
                        ColumnsMappingDialog.this.mappingViewer.refresh();
                    }
                }
            }
        });
        columnController.addColumn(DTUIMessages.columns_mapping_dialog_column_target_type_text, null, 16384, true, false, false, null, (CellLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)cell.getElement();
                DBPDataSource dataSource = ColumnsMappingDialog.this.settings.getTargetDataSource((DatabaseMappingObject)attrMapping);
                cell.setText(attrMapping.getTargetType(dataSource, true));
                cell.setFont(BaseThemeSettings.instance.treeAndTableFontBold);
            }
        }, new EditingSupport((ColumnViewer)this.mappingViewer){

            protected CellEditor getCellEditor(Object element) {
                DBPDataTypeProvider dataTypeProvider;
                Object dataTypes;
                DBPDataSource dataSource;
                DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)element;
                TreeMap<String, String> types = new TreeMap<String, String>();
                DBSObjectContainer container = ColumnsMappingDialog.this.settings.getContainer();
                if (container != null && (dataSource = container.getDataSource()) != null && !CommonUtils.isEmpty((Collection)(dataTypes = dataSource.getSQLDialect().getDataTypes(dataSource)))) {
                    Iterator iterator = dataTypes.iterator();
                    while (iterator.hasNext()) {
                        String dataType = (String)iterator.next();
                        types.put(dataType.toUpperCase(Locale.ROOT), dataType);
                    }
                }
                if ((dataTypeProvider = (DBPDataTypeProvider)DBUtils.getParentOfType(DBPDataTypeProvider.class, (DBSObject)container)) != null) {
                    for (DBSDataType type : dataTypeProvider.getLocalDataTypes()) {
                        types.put(type.getName().toUpperCase(Locale.ROOT), type.getName());
                    }
                }
                String targetType = attrMapping.getTargetType(ColumnsMappingDialog.this.settings.getTargetDataSource((DatabaseMappingObject)attrMapping), true);
                types.put(targetType.toUpperCase(Locale.ROOT), targetType);
                return new CustomComboBoxCellEditor((ColumnViewer)ColumnsMappingDialog.this.mappingViewer, (Composite)ColumnsMappingDialog.this.mappingViewer.getTable(), types.values().toArray(new String[0]), 2048);
            }

            protected boolean canEdit(Object element) {
                DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)element;
                return attrMapping.getMappingType() == DatabaseMappingType.create;
            }

            protected Object getValue(Object element) {
                DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)element;
                return attrMapping.getTargetType(ColumnsMappingDialog.this.settings.getTargetDataSource((DatabaseMappingObject)attrMapping), true);
            }

            protected void setValue(Object element, Object value) {
                DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)element;
                attrMapping.setTargetType(CommonUtils.toString((Object)value));
                ColumnsMappingDialog.this.mappingViewer.refresh(element);
            }
        });
        columnController.addColumn(DTUIMessages.columns_mapping_dialog_column_type_text_mapping, null, 16384, true, false, (CellLabelProvider)new ColumnLabelProvider(this){

            public String getText(Object element) {
                DatabaseMappingAttribute mapping = (DatabaseMappingAttribute)element;
                return switch (mapping.getMappingType()) {
                    case DatabaseMappingType.existing -> DTUIMessages.columns_mapping_dialog_cell_text_existing;
                    case DatabaseMappingType.create -> DTUIMessages.columns_mapping_dialog_cell_text_new;
                    case DatabaseMappingType.skip -> DTUIMessages.columns_mapping_dialog_cell_text_skip;
                    default -> "?";
                };
            }
        });
        columnController.addColumn(DTUIMessages.database_consumer_page_mapping_column_transformer_text, DTUIMessages.database_consumer_page_mapping_column_transformer_tip, 16384, true, false, new CellLabelProvider(this){

            public void update(ViewerCell cell) {
                DataTransferAttributeTransformerDescriptor transformer;
                Object element = cell.getElement();
                if (element instanceof DatabaseMappingAttribute && (transformer = ((DatabaseMappingAttribute)element).getTransformer()) != null) {
                    cell.setText(transformer.getName());
                    return;
                }
                cell.setText("");
            }
        });
        columnController.createColumns();
        this.mappingViewer.setInput(this.attributeMappings);
        this.setControl((Control)composite);
    }
}

