/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.sql.generator.SQLGenerator;
import org.jkiss.dbeaver.model.sql.generator.SQLGeneratorProcedureCall;
import org.jkiss.dbeaver.model.sql.generator.SQLGeneratorSelect;
import org.jkiss.dbeaver.model.sql.registry.SQLGeneratorConfigurationRegistry;
import org.jkiss.dbeaver.model.sql.registry.SQLGeneratorDescriptor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorFeatures;
import org.jkiss.dbeaver.ui.editors.sql.generator.SQLGeneratorDialog;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SQLGeneratorContributor
extends CompoundContributionItem {
    protected static final Log log = Log.getLog(SQLGeneratorContributor.class);

    protected IContributionItem[] getContributionItems() {
        IWorkbenchPart part = UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart();
        IStructuredSelection structuredSelection = NavigatorUtils.getSelectionFromPart((IWorkbenchPart)part);
        if (structuredSelection == null || structuredSelection.isEmpty()) {
            return new IContributionItem[0];
        }
        ArrayList<IContributionItem> menu = new ArrayList<IContributionItem>();
        if (structuredSelection instanceof IResultSetSelection) {
            this.makeResultSetContributions(menu, (IResultSetSelection)structuredSelection);
        } else {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Object obj : structuredSelection.toList()) {
                DBSObject adaptedObject;
                if (obj instanceof DBNDatabaseFolder) {
                    DBNDatabaseFolder folder = (DBNDatabaseFolder)obj;
                    adaptedObject = folder.getParentObject();
                } else {
                    adaptedObject = (DBSObject)GeneralUtils.adapt(obj, DBSObject.class);
                }
                if (adaptedObject != null) {
                    objects.add(adaptedObject);
                    continue;
                }
                if (obj instanceof DBSWrapper) {
                    objects.add(((DBSWrapper)obj).getObject());
                    continue;
                }
                if (!(obj instanceof DBPObject)) continue;
                objects.add((DBPObject)obj);
            }
            List generators = SQLGeneratorConfigurationRegistry.getInstance().getApplicableGenerators(objects, (Object)structuredSelection);
            int lastGrand = 0;
            for (SQLGeneratorDescriptor gen : generators) {
                int order = gen.getOrder();
                if (order > 0 && order / 1000 > lastGrand) {
                    menu.add((IContributionItem)new Separator());
                }
                lastGrand = order / 1000;
                menu.add((IContributionItem)SQLGeneratorContributor.makeAction(gen.getLabel(), gen, objects));
            }
        }
        return menu.toArray(new IContributionItem[0]);
    }

    private void makeResultSetContributions(List<IContributionItem> menu, IResultSetSelection rss) {
        IResultSetController rsv = rss.getController();
        DBSDataContainer dataContainer = rsv.getDataContainer();
        List visibleAttributes = rsv.getModel().getVisibleAttributes();
        DBSEntity entity = rsv.getModel().getSingleSource();
        if (dataContainer != null && !visibleAttributes.isEmpty() && entity != null) {
            ArrayList selectedRows = new ArrayList(rss.getSelectedRows());
            if (!CommonUtils.isEmpty(selectedRows)) {
                ArrayList<IResultSetController> objects = new ArrayList<IResultSetController>();
                objects.add(rsv);
                List generators = SQLGeneratorConfigurationRegistry.getInstance().getApplicableGenerators(objects, (Object)rsv);
                for (SQLGeneratorDescriptor gen : generators) {
                    if (gen.isMultiObject() && selectedRows.size() < 2) continue;
                    menu.add((IContributionItem)SQLGeneratorContributor.makeAction(gen.getLabel(), gen, objects));
                }
            }
        } else {
            String message = dataContainer == null ? "no data container" : (visibleAttributes.isEmpty() ? "empty attribute list" : "can't resolve table");
            Action disabledAction = new Action(this, "Not available - " + message){};
            disabledAction.setEnabled(false);
            menu.add((IContributionItem)new ActionContributionItem((IAction)disabledAction));
        }
    }

    public static boolean hasContributions(IStructuredSelection selection) {
        DBSObject object = (DBSObject)RuntimeUtils.getObjectAdapter((Object)selection.getFirstElement(), DBSObject.class);
        return object instanceof DBSTable || object instanceof DBPScriptObject;
    }

    private static ContributionItem makeAction(String text, final SQLGeneratorDescriptor sqlGenerator, final List<?> objects) {
        return new ActionContributionItem((IAction)new Action(text, DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.SQL_TEXT)){

            public void run() {
                DBSObject selectedObject;
                ISelectionProvider selectionProvider;
                IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
                IEditorPart activeEditor = activePage.getActiveEditor();
                DBCExecutionContext executionContext = null;
                IWorkbenchPart activePart = activePage.getActivePart();
                if (activePart != null && (selectionProvider = activePart.getSite().getSelectionProvider()) != null && (selectedObject = NavigatorUtils.getSelectedObject((ISelection)selectionProvider.getSelection())) != null) {
                    executionContext = DBUtils.getDefaultContext((DBSObject)selectedObject, (boolean)false);
                }
                if (executionContext == null && activeEditor instanceof DBPContextProvider) {
                    executionContext = ((DBPContextProvider)activeEditor).getExecutionContext();
                }
                if (executionContext != null) {
                    SQLGenerator generator;
                    try {
                        generator = sqlGenerator.createGenerator(objects);
                    }
                    catch (DBException e) {
                        DBWorkbench.getPlatformUI().showError("Generator create", "Can't create SQL generator '" + sqlGenerator.getId() + "'", (Throwable)e);
                        return;
                    }
                    SQLEditorFeatures.SQL_EDITOR_GENERATE_SQL_ON_OBJECT.use(Map.of("generator", generator.getClass().getSimpleName()));
                    SQLGeneratorDialog dialog = new SQLGeneratorDialog(activePage.getActivePart().getSite(), executionContext, generator);
                    dialog.setWordWrap(true);
                    dialog.open();
                }
            }
        });
    }

    @NotNull
    public static SQLGenerator<DBSEntity> SELECT_GENERATOR(List<DBSEntity> entities, boolean columnList) {
        SQLGeneratorSelect generatorSelect = new SQLGeneratorSelect();
        generatorSelect.initGenerator(entities);
        generatorSelect.setColumnList(columnList);
        return generatorSelect;
    }

    @NotNull
    public static SQLGenerator<DBSProcedure> CALL_GENERATOR(List<DBSProcedure> entities) {
        SQLGeneratorProcedureCall procedureCall = new SQLGeneratorProcedureCall();
        procedureCall.initGenerator(entities);
        return procedureCall;
    }
}

