/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.settings;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyGroupDescriptor;
import org.jkiss.dbeaver.registry.settings.ProductSettingDescriptor;

public class ProductSettingsRegistry {
    public static final String SETTINGS_EXTENSION_ID = "org.jkiss.dbeaver.settings";
    private static ProductSettingsRegistry instance = null;
    private final Map<String, PropertyGroupDescriptor<ProductSettingDescriptor>> settings = new LinkedHashMap<String, PropertyGroupDescriptor<ProductSettingDescriptor>>();

    public static synchronized ProductSettingsRegistry getInstance() {
        if (instance == null) {
            instance = new ProductSettingsRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ProductSettingsRegistry() {
    }

    private synchronized void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        for (IConfigurationElement ext : extConfigs = registry.getConfigurationElementsFor(SETTINGS_EXTENSION_ID)) {
            if (!"propertyGroup".equals(ext.getName())) continue;
            this.parseSettingsGroup(ext, null);
        }
    }

    private void parseSettingsGroup(IConfigurationElement ext, @Nullable PropertyGroupDescriptor<ProductSettingDescriptor> parentGroup) {
        PropertyGroupDescriptor<ProductSettingDescriptor> settingsGroup = new PropertyGroupDescriptor<ProductSettingDescriptor>(ext);
        if (this.settings.containsKey(settingsGroup.getId())) {
            settingsGroup = this.settings.get(settingsGroup.getId());
        } else {
            this.settings.put(settingsGroup.getId(), settingsGroup);
        }
        if (parentGroup != null) {
            settingsGroup.setParentGroup(parentGroup);
            parentGroup.addSubGroup(settingsGroup);
        }
        for (IConfigurationElement childExt : ext.getChildren()) {
            if ("propertyGroup".equals(childExt.getName())) {
                this.parseSettingsGroup(childExt, settingsGroup);
                continue;
            }
            if (!"property".equals(childExt.getName())) continue;
            ProductSettingDescriptor productSettingDescriptor = new ProductSettingDescriptor(settingsGroup.getFullId(), childExt);
            settingsGroup.addProperty((PropertyDescriptor)productSettingDescriptor);
        }
    }

    public List<PropertyGroupDescriptor<ProductSettingDescriptor>> getSettings() {
        return new ArrayList<PropertyGroupDescriptor<ProductSettingDescriptor>>(this.settings.values());
    }
}

