/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.datatype;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.app.DBPRegistryDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.registry.datatype.ValueHandlerDescriptor;

public abstract class DataTypeAbstractDescriptor<DESCRIPTOR>
extends AbstractDescriptor
implements DBPRegistryDescriptor<DESCRIPTOR> {
    private static final Log log = Log.getLog(ValueHandlerDescriptor.class);
    public static final String ALL_TYPES_PATTERN = "*";
    private final Class<DESCRIPTOR> instanceType;
    private final String id;
    private final AbstractDescriptor.ObjectType implType;
    private final Set<Object> supportedTypes = new HashSet<Object>();
    private final List<String> supportedDataSources = new ArrayList<String>();
    private boolean hasAll;
    private boolean hasTypeIds;
    private boolean hasDataKinds;
    private boolean hasTypeNames;
    private boolean hasTypesWithTypedParams;
    protected DESCRIPTOR instance;

    public DataTypeAbstractDescriptor(@NotNull IConfigurationElement config, @NotNull Class<DESCRIPTOR> instanceType) {
        super(config);
        IConfigurationElement[] dsElements;
        IConfigurationElement[] typeElements;
        this.instanceType = instanceType;
        this.id = config.getAttribute("id");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        for (IConfigurationElement typeElement : typeElements = config.getChildren("type")) {
            String typeName = typeElement.getAttribute("name");
            if (typeName != null) {
                if (typeName.equals(ALL_TYPES_PATTERN)) {
                    this.hasAll = true;
                    continue;
                }
                if (typeName.endsWith(ALL_TYPES_PATTERN)) {
                    this.hasTypesWithTypedParams = true;
                }
                this.supportedTypes.add(typeName.toLowerCase(Locale.ENGLISH));
                this.hasTypeNames = true;
                continue;
            }
            typeName = typeElement.getAttribute("kind");
            if (typeName != null) {
                try {
                    this.supportedTypes.add(DBPDataKind.valueOf((String)typeName));
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)e);
                }
                this.hasDataKinds = true;
                continue;
            }
            typeName = typeElement.getAttribute("standard");
            if (typeName == null) {
                typeName = typeElement.getAttribute("id");
                if (typeName == null) {
                    log.warn((Object)"Type element without name or standard type reference");
                    continue;
                }
                try {
                    int typeNumber = Integer.parseInt(typeName);
                    this.supportedTypes.add(typeNumber);
                    this.hasTypeIds = true;
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Type ID must be an integer while '" + typeName + "' was specified"));
                }
                continue;
            }
            try {
                Field typeField = Types.class.getField(typeName);
                int typeNumber = typeField.getInt(null);
                this.supportedTypes.add(typeNumber);
                this.hasTypeIds = true;
            }
            catch (Exception e) {
                log.warn((Object)("Standard type '" + typeName + "' cannot be accessed"), (Throwable)e);
            }
        }
        for (IConfigurationElement dsElement : dsElements = config.getChildren("datasource")) {
            String dsId = dsElement.getAttribute("id");
            String dsClassName = dsElement.getAttribute("class");
            if (dsId == null && dsClassName == null) {
                log.warn((Object)"Datasource reference with null ID/Class");
                continue;
            }
            this.supportedDataSources.add(dsId != null ? dsId : dsClassName);
        }
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public DESCRIPTOR getInstance() {
        if (this.instance == null) {
            if (this.implType == null) {
                throw new IllegalStateException("Data type implementation not specified");
            }
            this.instance = this.createInstance();
        }
        return this.instance;
    }

    List<String> getSupportedDataSources() {
        return this.supportedDataSources;
    }

    @NotNull
    protected DESCRIPTOR createInstance() {
        try {
            return (DESCRIPTOR)this.implType.createInstance(this.instanceType);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't instantiate data type provider '" + this.getId() + "'", e);
        }
    }

    public boolean supportsType(@NotNull DBSTypedObject typedObject) {
        String typeName;
        if (this.hasAll || this.hasTypeIds && this.supportedTypes.contains(typedObject.getTypeID())) {
            return true;
        }
        if (this.hasTypeNames && (typeName = typedObject.getTypeName()) != null) {
            String lowerCaseTypeName = typeName.toLowerCase(Locale.ENGLISH);
            if (this.supportedTypes.contains(lowerCaseTypeName)) {
                return true;
            }
            if (this.hasTypesWithTypedParams) {
                boolean matchesTypeWithTypesParams = this.supportedTypes.stream().map(Object::toString).filter(t -> t.endsWith(ALL_TYPES_PATTERN)).map(t -> t.substring(0, t.length() - 1)).anyMatch(lowerCaseTypeName::startsWith);
                if (matchesTypeWithTypesParams) {
                    return true;
                }
            }
        }
        return this.hasDataKinds && this.supportedTypes.contains(typedObject.getDataKind());
    }

    public Set<Object> getSupportedTypes() {
        return this.supportedTypes;
    }

    public boolean isGlobal() {
        return this.supportedDataSources.isEmpty();
    }

    public boolean supportsDataSource(DBPDataSource dataSource) {
        for (DBPDataSourceProviderDescriptor provider = dataSource.getContainer().getDriver().getProviderDescriptor(); provider != null; provider = provider.getParentProvider()) {
            if (!this.supportedDataSources.contains(provider.getId())) continue;
            return true;
        }
        return this.supportedDataSources.contains(dataSource.getClass().getName());
    }

    public String toString() {
        return this.getId();
    }
}

