/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.fs.DBFFileSystemDescriptor;
import org.jkiss.dbeaver.model.fs.DBFFileSystemProvider;
import org.jkiss.dbeaver.model.fs.DBFPath;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.registry.fs.FileSystemProviderRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DBFUtils {
    private static final Log log = Log.getLog(DBFUtils.class);
    public static final String PRODUCT_FEATURE_MULTI_FS = "multi-fs";
    private static final String FILE_DATABASES_FOLDER = "File databases";
    private static volatile Boolean SUPPORT_MULTI_FS = null;
    private static final Map<FileSystem, String> fileSystemIdCache = new IdentityHashMap<FileSystem, String>();

    public static boolean supportsMultiFileSystems(@NotNull DBPProject project) {
        if (SUPPORT_MULTI_FS == null && (SUPPORT_MULTI_FS = Boolean.valueOf(DBWorkbench.getPlatform().getApplication().hasProductFeature(PRODUCT_FEATURE_MULTI_FS))) == null) {
            SUPPORT_MULTI_FS = false;
        }
        return SUPPORT_MULTI_FS;
    }

    @NotNull
    public static Path resolvePathFromString(@NotNull DBRProgressMonitor monitor, @Nullable DBPProject project, @NotNull String pathOrUri) throws DBException {
        if (project != null) {
            return project.getFileSystemManager().getPathFromString(monitor, pathOrUri);
        }
        return Path.of(pathOrUri, new String[0]);
    }

    @NotNull
    public static Path resolvePathFromURI(@NotNull DBRProgressMonitor monitor, @Nullable DBPProject project, @NotNull URI uri) throws DBException {
        if (project != null) {
            return project.getFileSystemManager().getPathFromURI(monitor, uri);
        }
        return Path.of(uri);
    }

    @NotNull
    public static Path resolvePathFromString(@NotNull DBRRunnableContext runnableContext, @Nullable DBPProject project, @NotNull String pathOrUri) throws DBException {
        if (!IOUtils.isLocalFile((String)pathOrUri) && project != null && DBFUtils.supportsMultiFileSystems(project)) {
            try {
                Path[] result = new Path[1];
                runnableContext.run(true, true, monitor -> {
                    try {
                        result[0] = project.getFileSystemManager().getPathFromString(monitor, pathOrUri);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                return result[0];
            }
            catch (InvocationTargetException e) {
                throw new DBException("Error getting path", e.getTargetException());
            }
            catch (InterruptedException e) {
                throw new DBException("Canceled");
            }
        }
        if (pathOrUri.startsWith("file:")) {
            try {
                return Path.of(new URI(pathOrUri));
            }
            catch (URISyntaxException e) {
                log.debug(e);
            }
        }
        return Path.of(pathOrUri, new String[0]);
    }

    public static String convertPathToString(@NotNull Path path) {
        return IOUtils.isLocalPath((Path)path) ? path.toString() : DBFUtils.getUriFromPath(path).toString();
    }

    public static URI getUriFromPath(Path path) {
        URI uri = path.toUri();
        String fileSystemId = DBFUtils.getFileSystemId(path.getFileSystem());
        if (!CommonUtils.isEmpty((String)fileSystemId)) {
            try {
                uri = !CommonUtils.isEmpty((String)uri.getAuthority()) ? new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "fs=" + fileSystemId, null) : new URI(uri.getScheme(), uri.getHost(), uri.getPath(), "fs=" + fileSystemId, null);
            }
            catch (URISyntaxException e) {
                log.debug("Error generating FS URI", e);
            }
        }
        return uri;
    }

    @NotNull
    public static Map<String, String> getQueryParameters(@Nullable String query) {
        String[] pairs;
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8) : pair;
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8) : null;
            result.put(key, value);
        }
        return result;
    }

    public static String getFileSystemId(FileSystem fs) {
        return fileSystemIdCache.get(fs);
    }

    public static void mapFileSystem(FileSystem fs, String id) {
        if (id == null) {
            fileSystemIdCache.remove(fs);
        } else {
            fileSystemIdCache.put(fs, id);
        }
    }

    @Nullable
    public static DBPDataSourceContainer createTemporaryDataSourceContainer(String connectionName, DBPProject project, DBPDriver driver, DBPConnectionConfiguration configuration) {
        DBPDataSourceRegistry registry = project.getDataSourceRegistry();
        String connectionId = "file_database_" + CommonUtils.truncateString((String)CommonUtils.escapeIdentifier((String)configuration.getDatabaseName()), (int)48) + "_" + String.valueOf(UUID.randomUUID());
        Optional<DBPDataSourceContainer> dataSourceContainerBox = registry.getDataSources().stream().filter(dbpDataSourceContainer -> Objects.equals(configuration.getDatabaseName(), dbpDataSourceContainer.getExtension("originalFilePath"))).findAny();
        if (dataSourceContainerBox.isPresent()) {
            log.debug("Datasource to :" + configuration.getDatabaseName() + " already exists");
            return dataSourceContainerBox.get();
        }
        Object dsContainer = registry.createDataSource(connectionId, driver, configuration);
        dsContainer.setExtension("originalFilePath", configuration.getDatabaseName());
        int conNameSuffix = 1;
        Object finalConnectionName = connectionName = "File - " + CommonUtils.truncateString((String)connectionName, (int)64);
        while (registry.findDataSourceByName((String)finalConnectionName) != null) {
            finalConnectionName = (String)connectionName + " " + ++conNameSuffix;
        }
        dsContainer.setName((String)finalConnectionName);
        dsContainer.setTemporary(true);
        DBPDataSourceFolder folder = registry.getFolder(FILE_DATABASES_FOLDER);
        dsContainer.setFolder(folder);
        dsContainer.setDescription("Temporary file datasource for " + configuration.getDatabaseName());
        try {
            registry.addDataSource((DBPDataSourceContainer)dsContainer);
        }
        catch (DBException e) {
            log.error(e);
            return null;
        }
        return dsContainer;
    }

    public static void move(@NotNull Path from, @NotNull Path to) throws IOException {
        if (IOUtils.isFileFromDefaultFS((Path)to)) {
            Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
            Files.delete(from);
        }
    }

    @Deprecated
    @Nullable
    public static Path getPathFromURI(@NotNull String fileUriString) throws DBException {
        DBFPath dbfPath = DBFUtils.getDBFPathFromURI(fileUriString);
        if (dbfPath == null) {
            return null;
        }
        return dbfPath.path();
    }

    @Nullable
    public static DBFPath getDBFPathFromURI(@NotNull String fileUriString) throws DBException {
        if (IOUtils.isLocalFile((String)fileUriString)) {
            Path path = Path.of(fileUriString, new String[0]).toAbsolutePath();
            return DBFPath.create(path);
        }
        URI fileUri = URI.create(fileUriString);
        if (!fileUri.isAbsolute() || fileUri.getScheme() == null) {
            Path path = Path.of(fileUriString, new String[0]).toAbsolutePath();
            return DBFPath.create(path);
        }
        FileSystem defaultFs = FileSystems.getDefault();
        if (defaultFs.provider().getScheme().equals(fileUri.getScheme())) {
            Path path = defaultFs.provider().getPath(fileUri);
            return DBFPath.create(path);
        }
        DBFFileSystemDescriptor externalFsProvider = FileSystemProviderRegistry.getInstance().getFileSystemProviderBySchema(fileUri.getScheme());
        if (externalFsProvider == null) {
            log.error("File system not found for scheme: " + fileUri.getScheme());
            return null;
        }
        DBFFileSystemProvider fileSystemProvider = externalFsProvider.getInstance();
        ClassLoader fsClassloader = fileSystemProvider.getClass().getClassLoader();
        Map<String, ?> env = fileSystemProvider.prepareEnv(System.getenv());
        try {
            FileSystem externalFileSystem = FileSystems.newFileSystem(fileUri, env, fsClassloader);
            Path path = externalFileSystem.provider().getPath(fileUri);
            return DBFPath.createExclusive(path);
        }
        catch (Exception e) {
            log.error("Failed to initialize path: " + String.valueOf(fileUri), e);
            return null;
        }
    }
}

