/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DBPConnectionBootstrap {
    private String defaultCatalogName;
    private String defaultSchemaName;
    private Boolean defaultAutoCommit;
    private Integer defaultTransactionIsolation;
    private final List<String> initQueries;
    private boolean ignoreErrors;

    public DBPConnectionBootstrap() {
        this.initQueries = new ArrayList<String>();
        this.ignoreErrors = false;
    }

    public DBPConnectionBootstrap(@NotNull DBPConnectionBootstrap info) {
        this.defaultCatalogName = info.defaultCatalogName;
        this.defaultSchemaName = info.defaultSchemaName;
        this.defaultAutoCommit = info.defaultAutoCommit;
        this.defaultTransactionIsolation = info.defaultTransactionIsolation;
        this.initQueries = new ArrayList<String>(info.initQueries);
        this.ignoreErrors = info.ignoreErrors;
    }

    @NotNull
    public List<String> getInitQueries() {
        return this.initQueries;
    }

    public void setInitQueries(Collection<String> queries) {
        this.initQueries.clear();
        this.initQueries.addAll(queries);
    }

    @Nullable
    public String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    public void setDefaultCatalogName(@Nullable String defaultCatalogName) {
        this.defaultCatalogName = defaultCatalogName;
    }

    @Nullable
    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public void setDefaultSchemaName(@Nullable String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName;
    }

    @Nullable
    public Boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(@Nullable Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    @Nullable
    public Integer getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(@Nullable Integer defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean hasData() {
        return this.defaultAutoCommit != null || this.defaultTransactionIsolation != null || !CommonUtils.isEmpty((String)this.defaultCatalogName) || !CommonUtils.isEmpty((String)this.defaultSchemaName) || this.ignoreErrors || !CommonUtils.isEmpty(this.initQueries);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBPConnectionBootstrap)) {
            return false;
        }
        DBPConnectionBootstrap source = (DBPConnectionBootstrap)obj;
        return CommonUtils.equalObjects((Object)this.defaultCatalogName, (Object)source.defaultCatalogName) && CommonUtils.equalObjects((Object)this.defaultSchemaName, (Object)source.defaultSchemaName) && CommonUtils.equalObjects((Object)this.defaultAutoCommit, (Object)source.defaultAutoCommit) && CommonUtils.equalObjects((Object)this.defaultTransactionIsolation, (Object)source.defaultTransactionIsolation) && CommonUtils.equalObjects(this.initQueries, source.initQueries) && this.ignoreErrors == source.ignoreErrors;
    }

    void resolveDynamicVariables(IVariableResolver variableResolver) {
        this.defaultCatalogName = GeneralUtils.replaceVariables(this.defaultCatalogName, variableResolver);
        this.defaultSchemaName = GeneralUtils.replaceVariables(this.defaultSchemaName, variableResolver);
        for (int i = 0; i < this.initQueries.size(); ++i) {
            this.initQueries.set(i, GeneralUtils.replaceVariables(this.initQueries.get(i), variableResolver));
        }
    }
}

