/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.navigator;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.dashboard.navigator.DBNDashboard;
import org.jkiss.dbeaver.model.dashboard.navigator.DBNDashboardFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.editor.DashboardEditorStandalone;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfigurationList;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;
import org.jkiss.dbeaver.utils.ResourceUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DashboardResourceHandler
extends AbstractResourceHandler {
    private static final Log log = Log.getLog(DashboardResourceHandler.class);

    public static IFolder getDashboardsFolder(DBPProject project, boolean forceCreate) throws CoreException {
        return DBPPlatformDesktop.getInstance().getWorkspace().getResourceDefaultRoot(project, DashboardResourceHandler.class, forceCreate);
    }

    public int getFeatures(IResource resource) {
        if (resource instanceof IFolder) {
            if (resource.getParent() instanceof IFolder) {
                return 30;
            }
            return 20;
        }
        return 11;
    }

    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        if (resource instanceof IFolder) {
            return "dashboard folder";
        }
        return "dashboard";
    }

    @NotNull
    public DBNResource makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) throws CoreException, DBException {
        if (resource instanceof IFile) {
            return new DBNDashboard(parentNode, resource, (DBPResourceHandler)this);
        }
        return new DBNDashboardFolder(parentNode, resource, (DBPResourceHandler)this);
    }

    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        if (!(resource instanceof IFile)) {
            super.openResource(resource);
            return;
        }
        FileEditorInput erdInput = new FileEditorInput((IFile)resource);
        UIUtils.getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)erdInput, DashboardEditorStandalone.class.getName());
    }

    @Nullable
    public List<DBPDataSourceContainer> getAssociatedDataSources(DBNResource resource) {
        if (resource.getResource() instanceof IFile) {
            try {
                InputStream is;
                IResource iResource = resource.getResource();
                DBPProject projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(iResource.getProject());
                if (projectMeta == null) {
                    return Collections.emptyList();
                }
                if (iResource instanceof IFile && (is = ((IFile)iResource).getContents()) != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                return null;
            }
        }
        return super.getAssociatedDataSources(resource);
    }

    public static IFile createDashboard(String title, IFolder folder, DBRProgressMonitor monitor) throws DBException {
        if (folder == null) {
            try {
                folder = DashboardResourceHandler.getDashboardsFolder(DBWorkbench.getPlatform().getWorkspace().getActiveProject(), true);
            }
            catch (CoreException e) {
                throw new DBException("Can't obtain folder for dashboard", (Throwable)e);
            }
        }
        if (folder == null) {
            throw new DBException("Can't detect folder for dashboard");
        }
        ResourceUtils.checkFolderExists((IFolder)folder, (DBRProgressMonitor)monitor);
        IFile file = ResourceUtils.getUniqueFile((IFolder)folder, (String)CommonUtils.escapeFileName((String)title), (String)"dashboard");
        DBPProject project = ((DBPPlatformDesktop)DBWorkbench.getPlatform(DBPPlatformDesktop.class)).getWorkspace().getProject(file.getProject());
        if (project == null) {
            throw new DBException("Can't detect project for file " + String.valueOf(file));
        }
        try {
            DBRRunnableWithProgress runnable = monitor1 -> {
                try {
                    DashboardConfigurationList configList = new DashboardConfigurationList(project, file);
                    configList.saveConfiguration();
                    file.refreshLocal(1, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor1));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            };
            if (monitor == null) {
                UIUtils.runInProgressService((DBRRunnableWithProgress)runnable);
            } else {
                runnable.run(monitor);
            }
        }
        catch (InvocationTargetException e) {
            throw new DBException("Error creating dashboard", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return file;
    }
}

