/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.dashboard.DashboardIcons;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardListViewer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfigurationList;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewer;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.SinglePageDatabaseEditor;

public class DashboardEditorStandalone
extends SinglePageDatabaseEditor<IEditorInput>
implements DashboardViewer,
IResourceChangeListener {
    private static final Log log = Log.getLog(DashboardEditorStandalone.class);
    private DashboardListViewer dashboardListViewer;
    private DashboardConfiguration dashboardConfig;
    private DashboardConfigurationList configurationList;

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void createEditorControl(Composite parent) {
        this.dashboardListViewer = new DashboardListViewer((IWorkbenchSite)this.getSite(), (IWorkbenchPart)this, this.configurationList, this.dashboardConfig);
        this.dashboardListViewer.createControl(parent);
        this.dashboardListViewer.createDashboardsFromConfiguration();
        this.getSite().setSelectionProvider((ISelectionProvider)this.dashboardListViewer);
    }

    public void setFocus() {
        Control control = this.dashboardListViewer.getControl();
        if (control != null) {
            control.setFocus();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        IFile file = EditorUtils.getFileFromInput((IEditorInput)input);
        if (file == null) {
            throw new PartInitException("Cannot get file from editor input " + String.valueOf(input));
        }
        DBPProject project = DBPPlatformDesktop.getInstance().getWorkspace().getProject(file.getProject());
        if (project == null) {
            throw new PartInitException("Cannot get project from file " + String.valueOf(file));
        }
        this.configurationList = new DashboardConfigurationList(project, file);
        this.configurationList.checkDefaultDashboardExistence();
        this.dashboardConfig = this.configurationList.getDashboards().get(0);
        String fileName = this.getEditorInput().getName();
        if (fileName.endsWith(".dashboard")) {
            fileName = fileName.substring(0, fileName.length() - 1 - "dashboard".length());
        }
        this.setTitleImage(DBeaverIcons.getImage((DBPImage)DashboardIcons.DASHBOARD));
        this.setPartName(fileName);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    private IFile getEditorFile() {
        return EditorUtils.getFileFromInput((IEditorInput)this.getEditorInput());
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        IFile file = this.getEditorFile();
        if (file == null) {
            return;
        }
        if ((delta = delta.findMember(file.getFullPath())) == null) {
            return;
        }
        if (delta.getKind() == 2) {
            if ((0x2000 & delta.getFlags()) != 0) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IFile newFile = workspace.getRoot().getFile(delta.getMovedToPath());
                this.setInput((IEditorInput)new FileEditorInput(newFile));
                this.setPartName(this.getEditorInput().getName());
            } else {
                UIUtils.asyncExec(() -> this.getSite().getWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, false));
            }
        }
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        return IRefreshablePart.RefreshResult.REFRESHED;
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dashboardConfig.getDataSourceContainer();
    }

    @Override
    public DashboardConfigurationList getConfigurationList() {
        return this.configurationList;
    }

    @Override
    public DashboardConfiguration getConfiguration() {
        return this.dashboardConfig;
    }

    @Override
    public DashboardListViewer getDashboardListViewer() {
        return this.dashboardListViewer;
    }

    @Override
    public void updateStatus() {
    }
}

