/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataType;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataTypeDomain;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class AltibaseDataTypeCache
extends JDBCBasicDataTypeCache<GenericStructContainer, AltibaseDataType> {
    public AltibaseDataTypeCache(GenericStructContainer owner) {
        super((DBSObject)owner);
    }

    protected synchronized void loadObjects(DBRProgressMonitor monitor, GenericStructContainer container) throws DBException {
        ArrayList<AltibaseDataType> tmpObjectList;
        block25: {
            AltibaseDataSource dataSource = (AltibaseDataSource)container.getDataSource();
            if (dataSource == null) {
                throw new DBException(ModelMessages.error_not_connected_to_database);
            }
            tmpObjectList = new ArrayList<AltibaseDataType>();
            try {
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Load Altibase data types");
                     JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM V$DATATYPE ORDER BY TYPE_NAME");){
                    monitor.subTask("Load Altibase domain types");
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            if (monitor.isCanceled()) {
                                break;
                            }
                            String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE_NAME");
                            if (typeName == null) continue;
                            boolean searchabel = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SEARCHABLE") > 0;
                            int precision = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"COLUMN_SIZE");
                            boolean unsinged = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"UNSIGNED_ATTRIBUTE") == 1;
                            String remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LOCAL_TYPE_NAME");
                            int minScale = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"MINIMUM_SCALE");
                            int maxScale = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"MAXIMUM_SCALE");
                            AltibaseDataTypeDomain fieldType = AltibaseDataTypeDomain.getByTypeName(typeName);
                            if (fieldType == null) continue;
                            AltibaseDataType dataType = new AltibaseDataType((GenericStructContainer)dataSource, fieldType, typeName, remarks, unsinged, searchabel, precision, minScale, maxScale);
                            tmpObjectList.add(dataType);
                        }
                    }
                }
                catch (SQLException ex) {
                    throw new DBDatabaseException((Throwable)ex, (DBPDataSource)dataSource);
                }
            }
            catch (DBException e) {
                if (this.handleCacheReadError((Exception)((Object)e))) break block25;
                throw e;
            }
        }
        this.mergeCache(tmpObjectList);
    }
}

