/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import java.util.Locale;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.utils.CommonUtils;

public class SQLDelimiterRule
implements TPRule {
    private final TPToken token;
    private char[][] delimiters;
    private char[][] origDelimiters;
    private char[] buffer;
    private char[] origBuffer;

    public SQLDelimiterRule(String[] delimiters, TPToken token) {
        this.token = token;
        char[][] cArrayArray = new char[delimiters.length][];
        this.delimiters = cArrayArray;
        this.origDelimiters = cArrayArray;
        int index = 0;
        int maxLength = 0;
        for (String delim : delimiters) {
            this.delimiters[index] = delim.toCharArray();
            for (int i = 0; i < this.delimiters[index].length; ++i) {
                this.delimiters[index][i] = Character.toUpperCase(this.delimiters[index][i]);
            }
            maxLength = Math.max(maxLength, this.delimiters[index].length);
            ++index;
        }
        this.buffer = new char[maxLength];
        this.origBuffer = this.buffer;
    }

    public char[][] getDelimiters() {
        return this.delimiters;
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        int i = 0;
        while (true) {
            int k;
            int c = scanner.read();
            boolean matches = false;
            if (c != -1) {
                c = Character.toUpperCase(c);
                for (k = 0; k < this.delimiters.length; ++k) {
                    if (i >= this.delimiters[k].length || this.delimiters[k][i] != c) continue;
                    this.buffer[i] = (char)c;
                    if (i == this.delimiters[k].length - 1 && this.equalsBegin(this.delimiters[k])) {
                        if (Character.isLetterOrDigit(c)) {
                            int cn = scanner.read();
                            scanner.unread();
                            if (Character.isUnicodeIdentifierPart(cn)) {
                                matches = false;
                                continue;
                            }
                        }
                        return this.token;
                    }
                    matches = true;
                    break;
                }
            }
            if (!matches) {
                for (k = 0; k <= i; ++k) {
                    scanner.unread();
                }
                return TPTokenAbstract.UNDEFINED;
            }
            ++i;
        }
    }

    private boolean equalsBegin(char[] delimiter) {
        for (int i = 0; i < delimiter.length; ++i) {
            if (this.buffer[i] == delimiter[i]) continue;
            return false;
        }
        return true;
    }

    public void changeDelimiter(String newDelimiter) {
        if (CommonUtils.isEmpty((String)newDelimiter)) {
            this.delimiters = this.origDelimiters;
            this.buffer = this.origBuffer;
        } else {
            for (char[] delim : this.delimiters) {
                String delimStr = String.valueOf(delim);
                if (newDelimiter.equals(delimStr)) {
                    return;
                }
                if (!newDelimiter.endsWith(delimStr)) continue;
                newDelimiter = newDelimiter.substring(0, newDelimiter.length() - delimStr.length()).trim();
            }
            this.delimiters = new char[1][];
            this.delimiters[0] = newDelimiter.toUpperCase(Locale.ENGLISH).toCharArray();
            this.buffer = new char[newDelimiter.length()];
        }
    }
}

