/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.format.tokenized;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.model.sql.format.tokenized.FormatterToken;
import org.jkiss.dbeaver.model.sql.format.tokenized.SQLFormatterTokenized;
import org.jkiss.dbeaver.model.sql.format.tokenized.TokenType;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

class IndentFormatter {
    private static final Log log = Log.getLog(SQLFormatterTokenized.class);
    private final SQLFormatterConfiguration formatterCfg;
    private final boolean isCompact;
    private final SQLDialect dialect;
    private List<String> statementDelimiters = new LinkedList<String>();
    private String delimiterRedefiner;
    private int indent = 0;
    private int bracketsDepth = 0;
    private boolean encounterBetween = false;
    private List<Boolean> functionBracket = new ArrayList<Boolean>();
    private List<Boolean> conditionBracket = new ArrayList<Boolean>();
    private final String[] blockHeaderStrings;
    private boolean isFirstConditionInBrackets;
    private static final String[] JOIN_BEGIN = new String[]{"LEFT", "RIGHT", "INNER", "OUTER", "FULL", "CROSS", "NATURAL", "JOIN"};
    private static final String[] NO_SPACE_IN_COMPACT_KEYWORDS = new String[]{"SELECT", "UPDATE", "INSERT", "DELETE", "FROM", "WHERE"};
    private static final String[] DML_KEYWORD = new String[]{"SELECT", "UPDATE", "INSERT", "DELETE"};
    private static final String[] CONDITION_KEYWORDS = new String[]{"WHERE", "ON", "HAVING"};

    IndentFormatter(SQLFormatterConfiguration formatterCfg, boolean isCompact) {
        this.formatterCfg = formatterCfg;
        this.delimiterRedefiner = formatterCfg.getSyntaxManager().getDialect().getScriptDelimiterRedefiner();
        if (this.statementDelimiters.contains(this.delimiterRedefiner)) {
            this.delimiterRedefiner = null;
        }
        if (this.delimiterRedefiner != null) {
            this.delimiterRedefiner = this.delimiterRedefiner.toUpperCase(Locale.ENGLISH);
        }
        for (String delim : formatterCfg.getSyntaxManager().getStatementDelimiters()) {
            if (CommonUtils.isEmptyTrimmed((String)delim)) continue;
            this.statementDelimiters.add(delim.toUpperCase(Locale.ENGLISH));
        }
        this.isCompact = isCompact;
        this.dialect = formatterCfg.getSyntaxManager().getDialect();
        this.blockHeaderStrings = this.dialect.getBlockHeaderStrings();
    }

    private int formatSymbol(String tokenString, List<Integer> bracketIndent, List<FormatterToken> argList, Integer index, FormatterToken prev) {
        int result = index;
        switch (tokenString) {
            case "(": {
                this.functionBracket.add(this.formatterCfg.isFunction(prev.getString()) || this.formatterCfg.isIdentifier(prev.getString()) ? Boolean.TRUE : Boolean.FALSE);
                this.conditionBracket.add(this.isCondition(argList, index) ? Boolean.TRUE : Boolean.FALSE);
                this.isFirstConditionInBrackets = true;
                bracketIndent.add(this.indent);
                ++this.bracketsDepth;
                if (this.isCompact || !this.formatterCfg.getPreferenceStore().getBoolean("sql.format.break.before.close.bracket")) break;
                ++this.indent;
                index = index + this.insertReturnAndIndent(argList, index + 1, this.indent);
                break;
            }
            case ")": {
                if (bracketIndent.isEmpty() || this.functionBracket.isEmpty() || this.conditionBracket.isEmpty()) break;
                this.indent = bracketIndent.remove(bracketIndent.size() - 1);
                if (!this.isCompact && this.formatterCfg.getPreferenceStore().getBoolean("sql.format.break.before.close.bracket")) {
                    result += this.insertReturnAndIndent(argList, index, this.indent);
                }
                this.functionBracket.remove(this.functionBracket.size() - 1);
                this.conditionBracket.remove(this.conditionBracket.size() - 1);
                --this.bracketsDepth;
                break;
            }
            case ",": {
                boolean isAfterInKeyword;
                if (this.isCompact) break;
                boolean isInsideAFunction = this.functionBracket.size() != 0 && this.functionBracket.get(this.functionBracket.size() - 1).equals(Boolean.TRUE);
                boolean bl = isAfterInKeyword = this.bracketsDepth > 0 && "IN".equalsIgnoreCase(this.getPrevKeyword(argList, index));
                if (isInsideAFunction || isAfterInKeyword) break;
                boolean lfBeforeComma = this.formatterCfg.getPreferenceStore().getBoolean("sql.format.lf.before.comma");
                result += this.insertReturnAndIndent(argList, lfBeforeComma ? index : index + 1, this.indent);
                break;
            }
            default: {
                if (!this.statementDelimiters.contains(tokenString)) break;
                this.indent = 0;
                result += this.insertReturnAndIndent(argList, index, this.indent);
            }
        }
        return result;
    }

    private int formatKeyword(List<FormatterToken> argList, String tokenString, int index) {
        int result = index;
        if (this.statementDelimiters.contains(tokenString)) {
            this.indent = 0;
            if (index > 0) {
                result += this.insertReturnAndIndent(argList, index - 1, this.indent);
            }
            result += this.insertReturnAndIndent(argList, index + 1, this.indent);
        } else if (this.blockHeaderStrings != null && ArrayUtils.contains((Object[])this.blockHeaderStrings, (Object)tokenString) || SQLUtils.isBlockStartKeyword((SQLDialect)this.dialect, (String)tokenString) && !"SELECT".equalsIgnoreCase(this.getPrevSpecialKeyword(argList, index, false))) {
            if (index > 0) {
                result += this.insertReturnAndIndent(argList, index, this.indent - 1);
            }
            ++this.indent;
            result += this.insertReturnAndIndent(argList, index + 1, this.indent);
        } else if (SQLUtils.isBlockEndKeyword((SQLDialect)this.dialect, (String)tokenString)) {
            --this.indent;
            result += this.insertReturnAndIndent(argList, index, this.indent);
        } else {
            switch (tokenString) {
                case "CREATE": {
                    int nextIndex;
                    if (!this.isCompact && (nextIndex = IndentFormatter.getNextKeywordIndex(argList, index)) > 0 && "OR".equals(argList.get(nextIndex).getString().toUpperCase(Locale.ENGLISH)) && (nextIndex = IndentFormatter.getNextKeywordIndex(argList, nextIndex)) > 0 && "REPLACE".equals(argList.get(nextIndex).getString().toUpperCase(Locale.ENGLISH))) {
                        this.insertReturnAndIndent(argList, nextIndex + 1, this.indent);
                        break;
                    }
                }
                case "DROP": 
                case "ALTER": 
                case "TABLE": {
                    break;
                }
                case "DELETE": 
                case "SELECT": 
                case "UPDATE": 
                case "INSERT": 
                case "INTO": 
                case "TRUNCATE": {
                    if (this.isCompact) break;
                    if (this.bracketsDepth > 0) {
                        result += this.insertReturnAndIndent(argList, index, this.indent);
                    } else if (index > 0) {
                        this.indent = 0;
                        result += this.insertReturnAndIndent(argList, index - 1, this.indent);
                    }
                    ++this.indent;
                    result += this.insertReturnAndIndent(argList, result + 1, this.indent);
                    break;
                }
                case "CASE": {
                    if (this.isCompact) break;
                    ++this.indent;
                    result += this.insertReturnAndIndent(argList, index + 1, this.indent);
                    break;
                }
                case "END": {
                    if (this.isCompact) break;
                    --this.indent;
                    result += this.insertReturnAndIndent(argList, index, this.indent);
                    break;
                }
                case "FROM": 
                case "WHERE": 
                case "START WITH": 
                case "CONNECT BY": 
                case "ORDER BY": 
                case "GROUP BY": 
                case "HAVING": {
                    result += this.insertReturnAndIndent(argList, index, this.indent - 1);
                    if (!this.isCompact) {
                        result += this.insertReturnAndIndent(argList, index + 1, this.indent);
                    }
                    this.isFirstConditionInBrackets = false;
                    break;
                }
                case "LEFT": 
                case "RIGHT": 
                case "INNER": 
                case "OUTER": 
                case "FULL": 
                case "CROSS": 
                case "NATURAL": 
                case "JOIN": {
                    if (this.isJoinStart(argList, index)) {
                        result += this.insertReturnAndIndent(argList, index, this.indent - 1);
                    }
                    if (!tokenString.equals("JOIN")) break;
                    break;
                }
                case "VALUES": 
                case "LIMIT": {
                    --this.indent;
                    result += this.insertReturnAndIndent(argList, index, this.indent);
                    break;
                }
                case "OR": {
                    if ("CREATE".equalsIgnoreCase(this.getPrevKeyword(argList, index))) break;
                    if (this.isFirstConditionInBrackets) {
                        result = this.checkConditionDepth(result, argList, index);
                    }
                }
                case "WHEN": {
                    if ("CASE".equalsIgnoreCase(this.getPrevKeyword(argList, index))) break;
                }
                case "ELSE": {
                    result += this.insertReturnAndIndent(argList, index, this.indent);
                    break;
                }
                case "SET": {
                    if (index > 1 && "UPDATE".equalsIgnoreCase(this.getPrevKeyword(argList, index))) {
                        result += this.insertReturnAndIndent(argList, index, this.indent - 1);
                    }
                    result += this.insertReturnAndIndent(argList, index + 1, this.indent);
                    break;
                }
                case "ON": {
                    result += this.insertReturnAndIndent(argList, index + 1, this.indent);
                    break;
                }
                case "USING": {
                    result += this.insertReturnAndIndent(argList, index, this.indent + 1);
                    break;
                }
                case "TOP": {
                    result += this.insertReturnAndIndent(argList, index, this.indent);
                    if (argList.size() >= index + 3) break;
                    result += this.insertReturnAndIndent(argList, index + 3, this.indent);
                    break;
                }
                case "UNION": 
                case "INTERSECT": 
                case "EXCEPT": {
                    this.indent -= 2;
                    result += this.insertReturnAndIndent(argList, index, this.indent);
                    ++this.indent;
                    break;
                }
                case "BETWEEN": {
                    this.encounterBetween = true;
                    break;
                }
                case "AND": {
                    if (!this.encounterBetween) {
                        result += this.insertReturnAndIndent(argList, index, this.indent);
                        if (this.isFirstConditionInBrackets) {
                            result = this.checkConditionDepth(result, argList, index);
                        }
                    }
                    this.encounterBetween = false;
                }
            }
        }
        return result;
    }

    public void format(List<FormatterToken> argList) {
        ArrayList<Integer> bracketIndent = new ArrayList<Integer>();
        FormatterToken prev = new FormatterToken(TokenType.SPACE, " ");
        for (int index = 0; index < argList.size(); ++index) {
            FormatterToken token = argList.get(index);
            String tokenString = token.getString().toUpperCase(Locale.ENGLISH);
            switch (token.getType()) {
                case SYMBOL: {
                    index = this.formatSymbol(tokenString, bracketIndent, argList, index, prev);
                    break;
                }
                case KEYWORD: {
                    index = this.formatKeyword(argList, tokenString, index);
                    break;
                }
                case COMMENT: {
                    index = this.formatComment(argList, index, token);
                    break;
                }
                case COMMAND: {
                    index = this.formatCommand(argList, index, token);
                    break;
                }
                case SPACE: {
                    index = this.formatSpace(argList, index, token);
                }
                default: {
                    if (!this.statementDelimiters.contains(tokenString)) break;
                    this.indent = 0;
                    index += this.insertReturnAndIndent(argList, index + 1, this.indent);
                }
            }
            prev = token;
        }
    }

    private int formatSpace(@NotNull List<? extends FormatterToken> argList, int index, @NotNull FormatterToken token) {
        String prevToken;
        if (token.getType() != TokenType.SPACE || !CommonUtils.isValidIndex((int)index, (int)(argList.size() - 1)) || index == 0) {
            return index;
        }
        if (this.isCompact && ((prevToken = argList.get(index - 1).getString()).equals(",") || Arrays.stream(NO_SPACE_IN_COMPACT_KEYWORDS).anyMatch(t -> t.equalsIgnoreCase(prevToken)))) {
            argList.remove(index);
            return index - 1;
        }
        if (argList.get(index - 1).getType() != TokenType.COMMENT || argList.get(index + 1).getType() != TokenType.NAME) {
            return index;
        }
        String tokenString = token.getString();
        int indexOfLastSeparator = tokenString.lastIndexOf(System.lineSeparator());
        if (indexOfLastSeparator == -1) {
            return index;
        }
        int indexAfterLastSeparator = indexOfLastSeparator + System.lineSeparator().length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            stringBuilder.append(this.formatterCfg.getIndentString());
        }
        String indentation = stringBuilder.toString();
        String afterLastSeparator = tokenString.substring(indexAfterLastSeparator);
        if (afterLastSeparator.equals(indentation)) {
            return index;
        }
        String newTokenString = tokenString.substring(0, indexAfterLastSeparator) + indentation;
        token.setString(newTokenString);
        return index;
    }

    private int formatCommand(List<FormatterToken> argList, int index, FormatterToken token) {
        String delimiter;
        String command;
        int divPos;
        this.indent = 0;
        if (index > 0) {
            index += this.insertReturnAndIndent(argList, index, 0);
        }
        index += this.insertReturnAndIndent(argList, index + 1, 0);
        if (!CommonUtils.isEmpty((String)this.delimiterRedefiner) && token.getString().startsWith(this.delimiterRedefiner) && (divPos = (command = token.getString().trim().toUpperCase(Locale.ENGLISH)).lastIndexOf(32)) > 0 && !CommonUtils.isEmpty((String)(delimiter = command.substring(divPos).trim()))) {
            this.statementDelimiters.clear();
            this.statementDelimiters.add(delimiter);
        }
        return index;
    }

    private int formatComment(List<FormatterToken> argList, int index, FormatterToken token) {
        Pair mlComments;
        boolean isComment = false;
        String[] slComments = this.formatterCfg.getSyntaxManager().getDialect().getSingleLineComments();
        if (slComments != null) {
            for (String slc : slComments) {
                if (!token.getString().startsWith(slc)) continue;
                index += this.insertReturnAndIndent(argList, index, this.indent);
                isComment = true;
                break;
            }
        }
        if (!isComment && (mlComments = this.formatterCfg.getSyntaxManager().getDialect().getMultiLineComments()) != null && token.getString().startsWith((String)mlComments.getFirst())) {
            index += this.insertReturnAndIndent(argList, index + 1, this.indent);
        }
        return index;
    }

    private int insertReturnAndIndent(List<FormatterToken> argList, int argIndex, int argIndent) {
        if (argIndex >= argList.size()) {
            return 0;
        }
        if (this.functionBracket.contains(Boolean.TRUE)) {
            return 0;
        }
        try {
            Object s = GeneralUtils.getDefaultLineSeparator();
            if (argIndex > 0) {
                FormatterToken prevToken = argList.get(argIndex - 1);
                if (prevToken.getType() == TokenType.COMMENT && SQLUtils.isCommentLine((SQLDialect)this.formatterCfg.getSyntaxManager().getDialect(), (String)prevToken.getString())) {
                    s = "";
                }
            } else if (argList.get(argIndex).getType() == TokenType.COMMENT) {
                s = "";
            }
            for (int index = 0; index < argIndent; ++index) {
                s = (String)s + this.formatterCfg.getIndentString();
            }
            FormatterToken token = argList.get(argIndex);
            if (token.getType() == TokenType.SPACE) {
                if (!token.getString().contains((CharSequence)s)) {
                    token.setString((String)s);
                }
                return 0;
            }
            boolean isDelimiter = this.statementDelimiters.contains(token.getString().toUpperCase());
            if (!isDelimiter && argIndex > 0 && (token = argList.get(argIndex - 1)).getType() == TokenType.SPACE) {
                token.setString((String)s);
                return 0;
            }
            if (isDelimiter) {
                if (argList.size() > argIndex + 1) {
                    FormatterToken lineFeed = new FormatterToken(TokenType.SPACE, (String)s + (String)s);
                    if (argList.get(argIndex + 1).getType() == TokenType.SPACE) {
                        argList.set(argIndex + 1, lineFeed);
                    } else {
                        argList.add(argIndex + 1, lineFeed);
                    }
                }
            } else {
                argList.add(argIndex, new FormatterToken(TokenType.SPACE, (String)s));
            }
            return 1;
        }
        catch (IndexOutOfBoundsException e) {
            log.debug((Object)e);
            return 0;
        }
    }

    private boolean isJoinStart(List<FormatterToken> argList, int index) {
        FormatterToken token;
        int i;
        if (!ArrayUtils.contains((Object[])JOIN_BEGIN, (Object)argList.get(index).getString().toUpperCase(Locale.ENGLISH))) {
            return false;
        }
        for (i = index - 1; i >= 0; --i) {
            token = argList.get(i);
            if (token.getType() == TokenType.SPACE || token.getType() == TokenType.SYMBOL) continue;
            if (!ArrayUtils.contains((Object[])JOIN_BEGIN, (Object)token.getString().toUpperCase(Locale.ENGLISH))) break;
            return false;
        }
        for (i = index; i < argList.size(); ++i) {
            token = argList.get(i);
            if (token.getType() == TokenType.SPACE || token.getType() == TokenType.SYMBOL) continue;
            if (token.getString().toUpperCase(Locale.ENGLISH).equals("JOIN")) {
                return true;
            }
            if (ArrayUtils.contains((Object[])JOIN_BEGIN, (Object)token.getString().toUpperCase(Locale.ENGLISH))) continue;
            return false;
        }
        return false;
    }

    private String getPrevKeyword(List<FormatterToken> argList, int index) {
        for (int i = index - 1; i >= 0; --i) {
            FormatterToken token = argList.get(i);
            if (token.getType() != TokenType.KEYWORD) continue;
            return token.getString();
        }
        return null;
    }

    private static int getNextKeywordIndex(List<FormatterToken> argList, int index) {
        for (int i = index + 1; i < argList.size(); ++i) {
            if (argList.get(i).getType() != TokenType.KEYWORD) continue;
            return i;
        }
        return -1;
    }

    private static String getNextKeyword(List<FormatterToken> argList, int index) {
        int ki = IndentFormatter.getNextKeywordIndex(argList, index);
        if (ki < 0) {
            return null;
        }
        return argList.get(ki).getString();
    }

    private String getPrevSpecialKeyword(List<FormatterToken> argList, int index, boolean isCondition) {
        for (int i = index - 1; i >= 0; --i) {
            FormatterToken token = argList.get(i);
            if (token.getType() != TokenType.KEYWORD) continue;
            String upperCaseToken = token.getString().toUpperCase(Locale.ENGLISH);
            if ((!isCondition || !ArrayUtils.contains((Object[])CONDITION_KEYWORDS, (Object)upperCaseToken)) && (isCondition || !ArrayUtils.contains((Object[])DML_KEYWORD, (Object)upperCaseToken))) continue;
            return token.getString();
        }
        return null;
    }

    private boolean isCondition(List<FormatterToken> argList, int index) {
        return this.getPrevSpecialKeyword(argList, index, true) != null;
    }

    private int checkConditionDepth(int result, List<FormatterToken> argList, int index) {
        if (this.conditionBracket.size() != 0 && this.conditionBracket.get(this.conditionBracket.size() - 1).equals(Boolean.TRUE)) {
            ++this.indent;
            this.isFirstConditionInBrackets = false;
            return result += this.insertReturnAndIndent(argList, index, this.indent);
        }
        return result;
    }
}

