/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.plan;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgrePlanNodeBase;
import org.jkiss.dbeaver.model.DBPDataSource;

public class PostgrePlanNodeText
extends PostgrePlanNodeBase<PostgrePlanNodeText> {
    private static final int OPERATION_LEN_MIN = 2;
    private static final String SEPARATOR = " ";
    private static final String OPTIONS_SEPARATOR = ":";
    private static final Set<String> OPERATION_TABLES = new HashSet<String>(Arrays.asList("Insert", "Update", "Delete", "Seq", "Foreign"));
    private static final Set<String> OPERATION_INDEXES = new HashSet<String>(Arrays.asList("Index"));
    private static final Set<String> OPERATION_FUNCTION = new HashSet<String>(Arrays.asList("Subquery", "Function"));
    public static final String ATTR_ADD_NAME = "Info";
    private int infoSeq = 0;
    private int indent;

    public int getIndent() {
        return this.indent;
    }

    private int getTokenIndex(String[] tokens, int start, String marker) {
        return this.getTokenIndex(tokens, start, marker, false);
    }

    private int getTokenIndex(String[] tokens, int start, String marker, boolean caseSensetive) {
        if (start < 0 || start >= tokens.length) {
            return -1;
        }
        for (int index = start; index < tokens.length; ++index) {
            if (!(caseSensetive ? tokens[index].equals(marker) : tokens[index].equalsIgnoreCase(marker))) continue;
            return index;
        }
        return -1;
    }

    private String getTokenAfter(String[] tokens, int start, String marker) {
        int tokenIndex = this.getTokenIndex(tokens, start, marker);
        if (tokenIndex < 0) {
            return null;
        }
        for (int index = tokenIndex; index < tokens.length; ++index) {
            if (tokens[index].length() == 0 || tokens[index] == SEPARATOR) continue;
            return index + 1 < tokens.length ? tokens[index + 1] : "";
        }
        return "";
    }

    private String removePrefix(String value) {
        int firstChar = 0;
        for (int index = 0; index < value.length(); ++index) {
            if (!Character.isLetter(value.charAt(index))) continue;
            firstChar = index;
            break;
        }
        if (firstChar == value.length() - 1) {
            return "";
        }
        return value.substring(firstChar);
    }

    private String[] splitPair(String value) {
        String[] result = new String[]{"", ""};
        if (value == null) {
            return result;
        }
        String[] split = value.split("\\.\\.");
        if (split.length == 0) {
            return result;
        }
        if (split.length == 1) {
            result[0] = split[0];
            result[1] = null;
        } else {
            result[0] = split[0];
            result[1] = split[1];
        }
        return result;
    }

    private String getAdditional(String[] tokens) {
        StringBuilder sb = new StringBuilder();
        boolean isObjectName = false;
        for (int index = 1; index < tokens.length; ++index) {
            if (tokens[index].equals(SEPARATOR)) continue;
            if (tokens[index].startsWith("(")) break;
            if (isObjectName) {
                isObjectName = false;
                continue;
            }
            if (tokens[index].equalsIgnoreCase("on")) {
                isObjectName = true;
                continue;
            }
            if (sb.length() > 0) {
                sb.append(SEPARATOR);
            }
            sb.append(tokens[index]);
        }
        return sb.toString().trim();
    }

    private void addAttr(Map<String, String> attributes, String attrName1, String attrName2, String attrVal) {
        String[] pair = this.splitPair(attrVal);
        attributes.put(attrName1, pair[0]);
        attributes.put(attrName2, pair[1]);
    }

    private void addAttr(Map<String, String> attributes, String attrName, String attrVal) {
        attrName = attrName.startsWith("(") ? attrName.substring(1) : attrName;
        attrVal = attrVal.endsWith(")") ? attrVal.substring(0, attrVal.length() - 1) : attrVal;
        switch (attrName) {
            case "cost": {
                this.addAttr(attributes, "Startup-Cost", "Total-Cost", attrVal);
                break;
            }
            case "rows": {
                this.addAttr(attributes, "Plan-Rows", "Actual-Rows", attrVal);
                break;
            }
            default: {
                attributes.put(attrName, attrVal);
            }
        }
    }

    private void parseAttr(Map<String, String> attributes, String[] tokens) {
        for (String token : tokens) {
            int posSep = token.indexOf(61);
            if (posSep <= 0) continue;
            this.addAttr(attributes, token.substring(0, posSep), token.substring(posSep + 1));
        }
    }

    public void addProp(String line) {
        int optIdx = line.indexOf(OPTIONS_SEPARATOR);
        if (optIdx == -1) {
            this.attributes.put("Info " + ++this.infoSeq, line);
        } else {
            this.attributes.put(line.substring(0, optIdx).trim(), line.substring(optIdx + 1, line.length()).trim());
        }
    }

    public PostgrePlanNodeText(DBPDataSource dataSource, PostgrePlanNodeText parent, String line, int indent) {
        super(dataSource, parent);
        this.indent = indent;
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        String str = this.removePrefix(line);
        String[] tokens = str.split(SEPARATOR);
        if (tokens.length > 0) {
            String operation = tokens[0];
            this.parseObjName(attributes, tokens, operation);
            String addInfo = this.getAdditional(tokens);
            if (operation.length() >= 2 && addInfo.length() > 0) {
                attributes.put("Node-Type", addInfo);
            } else {
                attributes.put("Node-Type", operation);
                if (addInfo.length() > 0) {
                    attributes.put(ATTR_ADD_NAME, addInfo);
                }
            }
            this.parseAttr(attributes, tokens);
        }
        this.setAttributes(attributes);
        if (parent != null) {
            parent.nested.add(this);
        }
    }

    private void parseObjName(Map<String, String> attributes, String[] tokens, String operation) {
        String objName = this.getTokenAfter(tokens, 1, "on");
        if (objName != null) {
            if (OPERATION_TABLES.contains(operation)) {
                attributes.put("Relation-Name", objName);
            } else if (OPERATION_INDEXES.contains(operation)) {
                attributes.put("Index-Name", objName);
            } else if (OPERATION_FUNCTION.contains(operation)) {
                attributes.put("Function-Name", objName);
            } else {
                attributes.put("Object name", objName);
            }
        }
    }
}

