/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.qm.QMTransactionState;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.runtime.TasksJob;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.controls.txn.TransactionLogDialog;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class DataSourceCommitHandler
extends AbstractDataSourceHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBCExecutionContext context = DataSourceCommitHandler.getActiveExecutionContext((ExecutionEvent)event, (boolean)true);
        if (context != null && context.isConnected()) {
            DataSourceCommitHandler.execute(HandlerUtil.getActiveShell((ExecutionEvent)event), context);
        }
        return null;
    }

    public static void execute(@NotNull Shell shell, @NotNull DBCExecutionContext context) {
        TasksJob.runTask((String)"Commit transaction", monitor -> {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
            if (txnManager != null) {
                QMTransactionState txnInfo = QMUtils.getTransactionState((DBCExecutionContext)context);
                try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Commit transaction");){
                    txnManager.commit(session);
                }
                catch (DBCException e) {
                    throw new InvocationTargetException(e);
                }
                if (context.getDataSource().getContainer().getPreferenceStore().getBoolean("transaction.show.notifications")) {
                    DBeaverNotifications.showNotification((DBPDataSource)context.getDataSource(), (String)"commit", (String)("Transaction has been committed\n\nQuery count: " + txnInfo.getUpdateCount() + "\nDuration: " + RuntimeUtils.formatExecutionTime((long)(System.currentTimeMillis() - txnInfo.getTransactionStartTime())) + "\n"), null, () -> TransactionLogDialog.showDialog(shell, context, true));
                }
            }
        });
    }
}

