/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKeyColumnTable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableForeignKey;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyDeferability;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.utils.CommonUtils;

public class GenericTableForeignKey
extends JDBCTableForeignKey<GenericTableBase, GenericTableForeignKeyColumnTable, DBSEntityReferrer> {
    private static final Log log = Log.getLog(GenericTableForeignKey.class);
    private DBSForeignKeyDeferability deferability;
    private List<GenericTableForeignKeyColumnTable> columns;

    public GenericTableForeignKey(GenericTableBase table, String name, @Nullable String remarks, DBSEntityReferrer referencedKey, DBSForeignKeyModifyRule deleteRule, DBSForeignKeyModifyRule updateRule, DBSForeignKeyDeferability deferability, boolean persisted) {
        super((JDBCTable)table, name, remarks, (DBSEntityConstraint)referencedKey, deleteRule, updateRule, persisted);
        this.deferability = deferability;
    }

    @NotNull
    public GenericDataSource getDataSource() {
        return (GenericDataSource)((GenericTableBase)this.getTable()).getDataSource();
    }

    @Property(viewable=true, order=7)
    public DBSForeignKeyDeferability getDeferability() {
        return this.deferability;
    }

    public void setDeferability(DBSForeignKeyDeferability deferability) {
        this.deferability = deferability;
    }

    public List<GenericTableForeignKeyColumnTable> getAttributeReferences(@Nullable DBRProgressMonitor monitor) {
        return this.columns;
    }

    public void setAttributeReferences(List<GenericTableForeignKeyColumnTable> columns) throws DBException {
        this.columns = columns;
    }

    public void addColumn(GenericTableForeignKeyColumnTable column) {
        if (this.columns == null) {
            this.columns = new ArrayList<GenericTableForeignKeyColumnTable>();
        }
        this.columns.add(column);
    }

    void setColumns(DBRProgressMonitor monitor, List<GenericTableForeignKeyColumnTable> columns) {
        List refColumns;
        this.columns = columns;
        try {
            refColumns = ((DBSEntityReferrer)this.referencedConstraint).getAttributeReferences(monitor);
        }
        catch (DBException e) {
            log.error((Object)"Error getting referenced key columns", (Throwable)e);
            return;
        }
        if (refColumns != null && this.columns.size() > refColumns.size()) {
            int i = 0;
            while (i < this.columns.size()) {
                boolean duplicate = false;
                String colName = this.columns.get(i).getName();
                int k = i + 1;
                while (k < this.columns.size()) {
                    String colName2 = this.columns.get(k).getName();
                    if (CommonUtils.equalObjects((Object)colName, (Object)colName2)) {
                        this.columns.remove(k);
                        duplicate = true;
                        break;
                    }
                    ++k;
                }
                if (duplicate) continue;
                ++i;
            }
        }
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((GenericTableBase)this.getTable()).getCatalog(), ((GenericTableBase)this.getTable()).getSchema(), this.getTable(), this});
    }
}

