/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.rulers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;

public abstract class RulerProvider {
    public static final String PROPERTY_HORIZONTAL_RULER = "horizontal ruler";
    public static final String PROPERTY_RULER_VISIBILITY = "ruler$visibility";
    public static final String PROPERTY_VERTICAL_RULER = "vertical ruler";
    public static final int UNIT_CENTIMETERS = 1;
    public static final int UNIT_INCHES = 0;
    public static final int UNIT_PIXELS = 2;
    public static final int UNIT_CUSTOM = 3;
    protected List<RulerChangeListener> listeners = new CopyOnWriteArrayList<RulerChangeListener>();

    public void addRulerChangeListener(RulerChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void getAccGuideDescription(AccessibleEvent e, Object guide) {
        e.result = GEFMessages.Guide_Desc;
    }

    public void getAccGuideName(AccessibleEvent e, Object guide) {
        e.result = GEFMessages.Guide_Label;
    }

    public void getAccGuideValue(AccessibleControlEvent e, Object guide) {
        e.result = "" + this.getGuidePosition(guide);
    }

    public List<? extends Object> getAttachedModelObjects(Object guide) {
        return Collections.emptyList();
    }

    public List<? extends EditPart> getAttachedEditParts(Object guide, GraphicalViewer viewer) {
        List<? extends Object> attachedModelObjects = this.getAttachedModelObjects(guide);
        ArrayList<EditPart> attachedEditParts = new ArrayList<EditPart>(attachedModelObjects.size());
        for (Object object : attachedModelObjects) {
            EditPart editPart = viewer.getEditPartForModel(object);
            if (editPart == null) continue;
            attachedEditParts.add(editPart);
        }
        return attachedEditParts;
    }

    public Command getCreateGuideCommand(int position) {
        return UnexecutableCommand.INSTANCE;
    }

    public int getCustomRulerDPU() {
        return 1;
    }

    public Command getDeleteGuideCommand(Object guide) {
        return UnexecutableCommand.INSTANCE;
    }

    public Object getGuideAt(int position) {
        for (Object object : this.getGuides()) {
            if (position != this.getGuidePosition(object)) continue;
            return object;
        }
        return null;
    }

    public Command getMoveGuideCommand(Object guide, int positionDelta) {
        return UnexecutableCommand.INSTANCE;
    }

    public List<? extends Object> getGuides() {
        return Collections.emptyList();
    }

    public int[] getGuidePositions() {
        return new int[0];
    }

    public int getGuidePosition(Object guide) {
        return Integer.MIN_VALUE;
    }

    public Object getRuler() {
        return null;
    }

    public int getUnit() {
        return 0;
    }

    public void removeRulerChangeListener(RulerChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setUnit(int newUnit) {
    }
}

