/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class ScrollPaneSolver {
    public static final int NEVER = 0;
    public static final int AUTOMATIC = 1;
    public static final int ALWAYS = 2;

    public static Result solve(Rectangle clientArea, Viewport viewport, int hVis, int vVis, int vBarWidth, int hBarHeight) {
        boolean none;
        Result result = new Result();
        result.insets = new Insets();
        result.insets.bottom = hBarHeight;
        result.insets.right = vBarWidth;
        Dimension available = clientArea.getSize();
        Dimension guaranteed = new Dimension(available).shrink(vVis == 0 ? 0 : result.insets.right, hVis == 0 ? 0 : result.insets.bottom);
        guaranteed.width = Math.max(guaranteed.width, 0);
        guaranteed.height = Math.max(guaranteed.height, 0);
        int wHint = guaranteed.width;
        int hHint = guaranteed.height;
        Dimension preferred = viewport.getPreferredSize(wHint, hHint).getCopy();
        Insets viewportInsets = viewport.getInsets();
        Dimension viewportMinSize = new Dimension(viewportInsets.getWidth(), viewportInsets.getHeight());
        if (viewport.getContents() != null) {
            if (viewport.getContentsTracksHeight() && hHint > -1) {
                hHint = Math.max(0, hHint - viewportInsets.getHeight());
            }
            if (viewport.getContentsTracksWidth() && wHint > -1) {
                wHint = Math.max(0, wHint - viewportInsets.getWidth());
            }
            viewportMinSize.expand(viewport.getContents().getMinimumSize(wHint, hHint));
        }
        if (viewport.getContentsTracksHeight()) {
            preferred.height = viewportMinSize.height;
        }
        if (viewport.getContentsTracksWidth()) {
            preferred.width = viewportMinSize.width;
        }
        boolean both = !(none = available.contains(preferred)) && preferred.containsProper(guaranteed);
        boolean showV = both || preferred.height > available.height;
        boolean showH = both || preferred.width > available.width;
        result.showV = vVis != 0 && (showV || vVis == 2);
        boolean bl = result.showH = hVis != 0 && (showH || hVis == 2);
        if (!result.showV) {
            result.insets.right = 0;
        }
        if (!result.showH) {
            result.insets.bottom = 0;
        }
        result.viewportArea = clientArea.getShrinked(result.insets);
        viewport.setBounds(result.viewportArea);
        return result;
    }

    public static class Result {
        public boolean showH;
        public boolean showV;
        public Rectangle viewportArea;
        public Insets insets;
    }
}

