﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>

namespace Aws {
namespace SageMaker {
namespace Model {
enum class AutoMLMetricEnum {
  NOT_SET,
  Accuracy,
  MSE,
  F1,
  F1macro,
  AUC,
  RMSE,
  BalancedAccuracy,
  R2,
  Recall,
  RecallMacro,
  Precision,
  PrecisionMacro,
  MAE,
  MAPE,
  MASE,
  WAPE,
  AverageWeightedQuantileLoss
};

namespace AutoMLMetricEnumMapper {
AWS_SAGEMAKER_API AutoMLMetricEnum GetAutoMLMetricEnumForName(const Aws::String& name);

AWS_SAGEMAKER_API Aws::String GetNameForAutoMLMetricEnum(AutoMLMetricEnum value);
}  // namespace AutoMLMetricEnumMapper
}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
