﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/application-insights/ApplicationInsights_EXPORTS.h>
#include <aws/application-insights/model/LogPattern.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ApplicationInsights {
namespace Model {
class ListLogPatternsResult {
 public:
  AWS_APPLICATIONINSIGHTS_API ListLogPatternsResult() = default;
  AWS_APPLICATIONINSIGHTS_API ListLogPatternsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APPLICATIONINSIGHTS_API ListLogPatternsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the resource group.</p>
   */
  inline const Aws::String& GetResourceGroupName() const { return m_resourceGroupName; }
  template <typename ResourceGroupNameT = Aws::String>
  void SetResourceGroupName(ResourceGroupNameT&& value) {
    m_resourceGroupNameHasBeenSet = true;
    m_resourceGroupName = std::forward<ResourceGroupNameT>(value);
  }
  template <typename ResourceGroupNameT = Aws::String>
  ListLogPatternsResult& WithResourceGroupName(ResourceGroupNameT&& value) {
    SetResourceGroupName(std::forward<ResourceGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Web Services account ID for the resource group owner.</p>
   */
  inline const Aws::String& GetAccountId() const { return m_accountId; }
  template <typename AccountIdT = Aws::String>
  void SetAccountId(AccountIdT&& value) {
    m_accountIdHasBeenSet = true;
    m_accountId = std::forward<AccountIdT>(value);
  }
  template <typename AccountIdT = Aws::String>
  ListLogPatternsResult& WithAccountId(AccountIdT&& value) {
    SetAccountId(std::forward<AccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of log patterns.</p>
   */
  inline const Aws::Vector<LogPattern>& GetLogPatterns() const { return m_logPatterns; }
  template <typename LogPatternsT = Aws::Vector<LogPattern>>
  void SetLogPatterns(LogPatternsT&& value) {
    m_logPatternsHasBeenSet = true;
    m_logPatterns = std::forward<LogPatternsT>(value);
  }
  template <typename LogPatternsT = Aws::Vector<LogPattern>>
  ListLogPatternsResult& WithLogPatterns(LogPatternsT&& value) {
    SetLogPatterns(std::forward<LogPatternsT>(value));
    return *this;
  }
  template <typename LogPatternsT = LogPattern>
  ListLogPatternsResult& AddLogPatterns(LogPatternsT&& value) {
    m_logPatternsHasBeenSet = true;
    m_logPatterns.emplace_back(std::forward<LogPatternsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token used to retrieve the next page of results. This value is
   * <code>null</code> when there are no more results to return. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListLogPatternsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListLogPatternsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_resourceGroupName;

  Aws::String m_accountId;

  Aws::Vector<LogPattern> m_logPatterns;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_resourceGroupNameHasBeenSet = false;
  bool m_accountIdHasBeenSet = false;
  bool m_logPatternsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApplicationInsights
}  // namespace Aws
