﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53-recovery-readiness/Route53RecoveryReadinessRequest.h>
#include <aws/route53-recovery-readiness/Route53RecoveryReadiness_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Route53RecoveryReadiness {
namespace Model {

/**
 */
class GetRecoveryGroupReadinessSummaryRequest : public Route53RecoveryReadinessRequest {
 public:
  AWS_ROUTE53RECOVERYREADINESS_API GetRecoveryGroupReadinessSummaryRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetRecoveryGroupReadinessSummary"; }

  AWS_ROUTE53RECOVERYREADINESS_API Aws::String SerializePayload() const override;

  AWS_ROUTE53RECOVERYREADINESS_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The number of objects that you want to return with this call.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline GetRecoveryGroupReadinessSummaryRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token that identifies which batch of results you want to see.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetRecoveryGroupReadinessSummaryRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of a recovery group.</p>
   */
  inline const Aws::String& GetRecoveryGroupName() const { return m_recoveryGroupName; }
  inline bool RecoveryGroupNameHasBeenSet() const { return m_recoveryGroupNameHasBeenSet; }
  template <typename RecoveryGroupNameT = Aws::String>
  void SetRecoveryGroupName(RecoveryGroupNameT&& value) {
    m_recoveryGroupNameHasBeenSet = true;
    m_recoveryGroupName = std::forward<RecoveryGroupNameT>(value);
  }
  template <typename RecoveryGroupNameT = Aws::String>
  GetRecoveryGroupReadinessSummaryRequest& WithRecoveryGroupName(RecoveryGroupNameT&& value) {
    SetRecoveryGroupName(std::forward<RecoveryGroupNameT>(value));
    return *this;
  }
  ///@}
 private:
  int m_maxResults{0};

  Aws::String m_nextToken;

  Aws::String m_recoveryGroupName;
  bool m_maxResultsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_recoveryGroupNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53RecoveryReadiness
}  // namespace Aws
