﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ecs/ECS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ECS {
namespace Model {

/**
 * <p>An object representing the protection status details for a task. You can set
 * the protection status with the <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateTaskProtection.html">UpdateTaskProtection</a>
 * API and get the status of tasks with the <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_GetTaskProtection.html">GetTaskProtection</a>
 * API.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ProtectedTask">AWS
 * API Reference</a></p>
 */
class ProtectedTask {
 public:
  AWS_ECS_API ProtectedTask() = default;
  AWS_ECS_API ProtectedTask(Aws::Utils::Json::JsonView jsonValue);
  AWS_ECS_API ProtectedTask& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ECS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The task ARN.</p>
   */
  inline const Aws::String& GetTaskArn() const { return m_taskArn; }
  inline bool TaskArnHasBeenSet() const { return m_taskArnHasBeenSet; }
  template <typename TaskArnT = Aws::String>
  void SetTaskArn(TaskArnT&& value) {
    m_taskArnHasBeenSet = true;
    m_taskArn = std::forward<TaskArnT>(value);
  }
  template <typename TaskArnT = Aws::String>
  ProtectedTask& WithTaskArn(TaskArnT&& value) {
    SetTaskArn(std::forward<TaskArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The protection status of the task. If scale-in protection is on for a task,
   * the value is <code>true</code>. Otherwise, it is <code>false</code>.</p>
   */
  inline bool GetProtectionEnabled() const { return m_protectionEnabled; }
  inline bool ProtectionEnabledHasBeenSet() const { return m_protectionEnabledHasBeenSet; }
  inline void SetProtectionEnabled(bool value) {
    m_protectionEnabledHasBeenSet = true;
    m_protectionEnabled = value;
  }
  inline ProtectedTask& WithProtectionEnabled(bool value) {
    SetProtectionEnabled(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The epoch time when protection for the task will expire.</p>
   */
  inline const Aws::Utils::DateTime& GetExpirationDate() const { return m_expirationDate; }
  inline bool ExpirationDateHasBeenSet() const { return m_expirationDateHasBeenSet; }
  template <typename ExpirationDateT = Aws::Utils::DateTime>
  void SetExpirationDate(ExpirationDateT&& value) {
    m_expirationDateHasBeenSet = true;
    m_expirationDate = std::forward<ExpirationDateT>(value);
  }
  template <typename ExpirationDateT = Aws::Utils::DateTime>
  ProtectedTask& WithExpirationDate(ExpirationDateT&& value) {
    SetExpirationDate(std::forward<ExpirationDateT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_taskArn;
  bool m_taskArnHasBeenSet = false;

  bool m_protectionEnabled{false};
  bool m_protectionEnabledHasBeenSet = false;

  Aws::Utils::DateTime m_expirationDate{};
  bool m_expirationDateHasBeenSet = false;
};

}  // namespace Model
}  // namespace ECS
}  // namespace Aws
