﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/securityhub/model/AwsLambdaFunctionCode.h>
#include <aws/securityhub/model/AwsLambdaFunctionDeadLetterConfig.h>
#include <aws/securityhub/model/AwsLambdaFunctionEnvironment.h>
#include <aws/securityhub/model/AwsLambdaFunctionLayer.h>
#include <aws/securityhub/model/AwsLambdaFunctionTracingConfig.h>
#include <aws/securityhub/model/AwsLambdaFunctionVpcConfig.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>Details about an Lambda function's configuration.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsLambdaFunctionDetails">AWS
 * API Reference</a></p>
 */
class AwsLambdaFunctionDetails {
 public:
  AWS_SECURITYHUB_API AwsLambdaFunctionDetails() = default;
  AWS_SECURITYHUB_API AwsLambdaFunctionDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AwsLambdaFunctionDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>An <code>AwsLambdaFunctionCode</code> object.</p>
   */
  inline const AwsLambdaFunctionCode& GetCode() const { return m_code; }
  inline bool CodeHasBeenSet() const { return m_codeHasBeenSet; }
  template <typename CodeT = AwsLambdaFunctionCode>
  void SetCode(CodeT&& value) {
    m_codeHasBeenSet = true;
    m_code = std::forward<CodeT>(value);
  }
  template <typename CodeT = AwsLambdaFunctionCode>
  AwsLambdaFunctionDetails& WithCode(CodeT&& value) {
    SetCode(std::forward<CodeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The SHA256 hash of the function's deployment package.</p>
   */
  inline const Aws::String& GetCodeSha256() const { return m_codeSha256; }
  inline bool CodeSha256HasBeenSet() const { return m_codeSha256HasBeenSet; }
  template <typename CodeSha256T = Aws::String>
  void SetCodeSha256(CodeSha256T&& value) {
    m_codeSha256HasBeenSet = true;
    m_codeSha256 = std::forward<CodeSha256T>(value);
  }
  template <typename CodeSha256T = Aws::String>
  AwsLambdaFunctionDetails& WithCodeSha256(CodeSha256T&& value) {
    SetCodeSha256(std::forward<CodeSha256T>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The function's dead letter queue.</p>
   */
  inline const AwsLambdaFunctionDeadLetterConfig& GetDeadLetterConfig() const { return m_deadLetterConfig; }
  inline bool DeadLetterConfigHasBeenSet() const { return m_deadLetterConfigHasBeenSet; }
  template <typename DeadLetterConfigT = AwsLambdaFunctionDeadLetterConfig>
  void SetDeadLetterConfig(DeadLetterConfigT&& value) {
    m_deadLetterConfigHasBeenSet = true;
    m_deadLetterConfig = std::forward<DeadLetterConfigT>(value);
  }
  template <typename DeadLetterConfigT = AwsLambdaFunctionDeadLetterConfig>
  AwsLambdaFunctionDetails& WithDeadLetterConfig(DeadLetterConfigT&& value) {
    SetDeadLetterConfig(std::forward<DeadLetterConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The function's environment variables.</p>
   */
  inline const AwsLambdaFunctionEnvironment& GetEnvironment() const { return m_environment; }
  inline bool EnvironmentHasBeenSet() const { return m_environmentHasBeenSet; }
  template <typename EnvironmentT = AwsLambdaFunctionEnvironment>
  void SetEnvironment(EnvironmentT&& value) {
    m_environmentHasBeenSet = true;
    m_environment = std::forward<EnvironmentT>(value);
  }
  template <typename EnvironmentT = AwsLambdaFunctionEnvironment>
  AwsLambdaFunctionDetails& WithEnvironment(EnvironmentT&& value) {
    SetEnvironment(std::forward<EnvironmentT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the function.</p>
   */
  inline const Aws::String& GetFunctionName() const { return m_functionName; }
  inline bool FunctionNameHasBeenSet() const { return m_functionNameHasBeenSet; }
  template <typename FunctionNameT = Aws::String>
  void SetFunctionName(FunctionNameT&& value) {
    m_functionNameHasBeenSet = true;
    m_functionName = std::forward<FunctionNameT>(value);
  }
  template <typename FunctionNameT = Aws::String>
  AwsLambdaFunctionDetails& WithFunctionName(FunctionNameT&& value) {
    SetFunctionName(std::forward<FunctionNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The function that Lambda calls to begin executing your function.</p>
   */
  inline const Aws::String& GetHandler() const { return m_handler; }
  inline bool HandlerHasBeenSet() const { return m_handlerHasBeenSet; }
  template <typename HandlerT = Aws::String>
  void SetHandler(HandlerT&& value) {
    m_handlerHasBeenSet = true;
    m_handler = std::forward<HandlerT>(value);
  }
  template <typename HandlerT = Aws::String>
  AwsLambdaFunctionDetails& WithHandler(HandlerT&& value) {
    SetHandler(std::forward<HandlerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The KMS key that is used to encrypt the function's environment variables.
   * This key is only returned if you've configured a customer managed customer
   * managed key.</p>
   */
  inline const Aws::String& GetKmsKeyArn() const { return m_kmsKeyArn; }
  inline bool KmsKeyArnHasBeenSet() const { return m_kmsKeyArnHasBeenSet; }
  template <typename KmsKeyArnT = Aws::String>
  void SetKmsKeyArn(KmsKeyArnT&& value) {
    m_kmsKeyArnHasBeenSet = true;
    m_kmsKeyArn = std::forward<KmsKeyArnT>(value);
  }
  template <typename KmsKeyArnT = Aws::String>
  AwsLambdaFunctionDetails& WithKmsKeyArn(KmsKeyArnT&& value) {
    SetKmsKeyArn(std::forward<KmsKeyArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates when the function was last updated.</p> <p>For more information
   * about the validation and formatting of timestamp fields in Security Hub, see <a
   * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.</p>
   */
  inline const Aws::String& GetLastModified() const { return m_lastModified; }
  inline bool LastModifiedHasBeenSet() const { return m_lastModifiedHasBeenSet; }
  template <typename LastModifiedT = Aws::String>
  void SetLastModified(LastModifiedT&& value) {
    m_lastModifiedHasBeenSet = true;
    m_lastModified = std::forward<LastModifiedT>(value);
  }
  template <typename LastModifiedT = Aws::String>
  AwsLambdaFunctionDetails& WithLastModified(LastModifiedT&& value) {
    SetLastModified(std::forward<LastModifiedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The function's layers.</p>
   */
  inline const Aws::Vector<AwsLambdaFunctionLayer>& GetLayers() const { return m_layers; }
  inline bool LayersHasBeenSet() const { return m_layersHasBeenSet; }
  template <typename LayersT = Aws::Vector<AwsLambdaFunctionLayer>>
  void SetLayers(LayersT&& value) {
    m_layersHasBeenSet = true;
    m_layers = std::forward<LayersT>(value);
  }
  template <typename LayersT = Aws::Vector<AwsLambdaFunctionLayer>>
  AwsLambdaFunctionDetails& WithLayers(LayersT&& value) {
    SetLayers(std::forward<LayersT>(value));
    return *this;
  }
  template <typename LayersT = AwsLambdaFunctionLayer>
  AwsLambdaFunctionDetails& AddLayers(LayersT&& value) {
    m_layersHasBeenSet = true;
    m_layers.emplace_back(std::forward<LayersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>For Lambda@Edge functions, the ARN of the master function.</p>
   */
  inline const Aws::String& GetMasterArn() const { return m_masterArn; }
  inline bool MasterArnHasBeenSet() const { return m_masterArnHasBeenSet; }
  template <typename MasterArnT = Aws::String>
  void SetMasterArn(MasterArnT&& value) {
    m_masterArnHasBeenSet = true;
    m_masterArn = std::forward<MasterArnT>(value);
  }
  template <typename MasterArnT = Aws::String>
  AwsLambdaFunctionDetails& WithMasterArn(MasterArnT&& value) {
    SetMasterArn(std::forward<MasterArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The memory that is allocated to the function.</p>
   */
  inline int GetMemorySize() const { return m_memorySize; }
  inline bool MemorySizeHasBeenSet() const { return m_memorySizeHasBeenSet; }
  inline void SetMemorySize(int value) {
    m_memorySizeHasBeenSet = true;
    m_memorySize = value;
  }
  inline AwsLambdaFunctionDetails& WithMemorySize(int value) {
    SetMemorySize(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The latest updated revision of the function or alias.</p>
   */
  inline const Aws::String& GetRevisionId() const { return m_revisionId; }
  inline bool RevisionIdHasBeenSet() const { return m_revisionIdHasBeenSet; }
  template <typename RevisionIdT = Aws::String>
  void SetRevisionId(RevisionIdT&& value) {
    m_revisionIdHasBeenSet = true;
    m_revisionId = std::forward<RevisionIdT>(value);
  }
  template <typename RevisionIdT = Aws::String>
  AwsLambdaFunctionDetails& WithRevisionId(RevisionIdT&& value) {
    SetRevisionId(std::forward<RevisionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The function's execution role.</p>
   */
  inline const Aws::String& GetRole() const { return m_role; }
  inline bool RoleHasBeenSet() const { return m_roleHasBeenSet; }
  template <typename RoleT = Aws::String>
  void SetRole(RoleT&& value) {
    m_roleHasBeenSet = true;
    m_role = std::forward<RoleT>(value);
  }
  template <typename RoleT = Aws::String>
  AwsLambdaFunctionDetails& WithRole(RoleT&& value) {
    SetRole(std::forward<RoleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The runtime environment for the Lambda function.</p>
   */
  inline const Aws::String& GetRuntime() const { return m_runtime; }
  inline bool RuntimeHasBeenSet() const { return m_runtimeHasBeenSet; }
  template <typename RuntimeT = Aws::String>
  void SetRuntime(RuntimeT&& value) {
    m_runtimeHasBeenSet = true;
    m_runtime = std::forward<RuntimeT>(value);
  }
  template <typename RuntimeT = Aws::String>
  AwsLambdaFunctionDetails& WithRuntime(RuntimeT&& value) {
    SetRuntime(std::forward<RuntimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The amount of time that Lambda allows a function to run before stopping
   * it.</p>
   */
  inline int GetTimeout() const { return m_timeout; }
  inline bool TimeoutHasBeenSet() const { return m_timeoutHasBeenSet; }
  inline void SetTimeout(int value) {
    m_timeoutHasBeenSet = true;
    m_timeout = value;
  }
  inline AwsLambdaFunctionDetails& WithTimeout(int value) {
    SetTimeout(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The function's X-Ray tracing configuration.</p>
   */
  inline const AwsLambdaFunctionTracingConfig& GetTracingConfig() const { return m_tracingConfig; }
  inline bool TracingConfigHasBeenSet() const { return m_tracingConfigHasBeenSet; }
  template <typename TracingConfigT = AwsLambdaFunctionTracingConfig>
  void SetTracingConfig(TracingConfigT&& value) {
    m_tracingConfigHasBeenSet = true;
    m_tracingConfig = std::forward<TracingConfigT>(value);
  }
  template <typename TracingConfigT = AwsLambdaFunctionTracingConfig>
  AwsLambdaFunctionDetails& WithTracingConfig(TracingConfigT&& value) {
    SetTracingConfig(std::forward<TracingConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The function's networking configuration.</p>
   */
  inline const AwsLambdaFunctionVpcConfig& GetVpcConfig() const { return m_vpcConfig; }
  inline bool VpcConfigHasBeenSet() const { return m_vpcConfigHasBeenSet; }
  template <typename VpcConfigT = AwsLambdaFunctionVpcConfig>
  void SetVpcConfig(VpcConfigT&& value) {
    m_vpcConfigHasBeenSet = true;
    m_vpcConfig = std::forward<VpcConfigT>(value);
  }
  template <typename VpcConfigT = AwsLambdaFunctionVpcConfig>
  AwsLambdaFunctionDetails& WithVpcConfig(VpcConfigT&& value) {
    SetVpcConfig(std::forward<VpcConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the Lambda function.</p>
   */
  inline const Aws::String& GetVersion() const { return m_version; }
  inline bool VersionHasBeenSet() const { return m_versionHasBeenSet; }
  template <typename VersionT = Aws::String>
  void SetVersion(VersionT&& value) {
    m_versionHasBeenSet = true;
    m_version = std::forward<VersionT>(value);
  }
  template <typename VersionT = Aws::String>
  AwsLambdaFunctionDetails& WithVersion(VersionT&& value) {
    SetVersion(std::forward<VersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The instruction set architecture that the function uses. Valid values are
   * <code>x86_64</code> or <code>arm64</code>.</p>
   */
  inline const Aws::Vector<Aws::String>& GetArchitectures() const { return m_architectures; }
  inline bool ArchitecturesHasBeenSet() const { return m_architecturesHasBeenSet; }
  template <typename ArchitecturesT = Aws::Vector<Aws::String>>
  void SetArchitectures(ArchitecturesT&& value) {
    m_architecturesHasBeenSet = true;
    m_architectures = std::forward<ArchitecturesT>(value);
  }
  template <typename ArchitecturesT = Aws::Vector<Aws::String>>
  AwsLambdaFunctionDetails& WithArchitectures(ArchitecturesT&& value) {
    SetArchitectures(std::forward<ArchitecturesT>(value));
    return *this;
  }
  template <typename ArchitecturesT = Aws::String>
  AwsLambdaFunctionDetails& AddArchitectures(ArchitecturesT&& value) {
    m_architecturesHasBeenSet = true;
    m_architectures.emplace_back(std::forward<ArchitecturesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of deployment package that's used to deploy the function code to
   * Lambda. Set to <code>Image</code> for a container image and <code>Zip</code> for
   * a .zip file archive. </p>
   */
  inline const Aws::String& GetPackageType() const { return m_packageType; }
  inline bool PackageTypeHasBeenSet() const { return m_packageTypeHasBeenSet; }
  template <typename PackageTypeT = Aws::String>
  void SetPackageType(PackageTypeT&& value) {
    m_packageTypeHasBeenSet = true;
    m_packageType = std::forward<PackageTypeT>(value);
  }
  template <typename PackageTypeT = Aws::String>
  AwsLambdaFunctionDetails& WithPackageType(PackageTypeT&& value) {
    SetPackageType(std::forward<PackageTypeT>(value));
    return *this;
  }
  ///@}
 private:
  AwsLambdaFunctionCode m_code;
  bool m_codeHasBeenSet = false;

  Aws::String m_codeSha256;
  bool m_codeSha256HasBeenSet = false;

  AwsLambdaFunctionDeadLetterConfig m_deadLetterConfig;
  bool m_deadLetterConfigHasBeenSet = false;

  AwsLambdaFunctionEnvironment m_environment;
  bool m_environmentHasBeenSet = false;

  Aws::String m_functionName;
  bool m_functionNameHasBeenSet = false;

  Aws::String m_handler;
  bool m_handlerHasBeenSet = false;

  Aws::String m_kmsKeyArn;
  bool m_kmsKeyArnHasBeenSet = false;

  Aws::String m_lastModified;
  bool m_lastModifiedHasBeenSet = false;

  Aws::Vector<AwsLambdaFunctionLayer> m_layers;
  bool m_layersHasBeenSet = false;

  Aws::String m_masterArn;
  bool m_masterArnHasBeenSet = false;

  int m_memorySize{0};
  bool m_memorySizeHasBeenSet = false;

  Aws::String m_revisionId;
  bool m_revisionIdHasBeenSet = false;

  Aws::String m_role;
  bool m_roleHasBeenSet = false;

  Aws::String m_runtime;
  bool m_runtimeHasBeenSet = false;

  int m_timeout{0};
  bool m_timeoutHasBeenSet = false;

  AwsLambdaFunctionTracingConfig m_tracingConfig;
  bool m_tracingConfigHasBeenSet = false;

  AwsLambdaFunctionVpcConfig m_vpcConfig;
  bool m_vpcConfigHasBeenSet = false;

  Aws::String m_version;
  bool m_versionHasBeenSet = false;

  Aws::Vector<Aws::String> m_architectures;
  bool m_architecturesHasBeenSet = false;

  Aws::String m_packageType;
  bool m_packageTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
