# -*- coding: utf-8 -*-
# Copyright 2024 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the vyos_bgp_address_family module
"""


class Bgp_address_familyArgs(object):  # pylint: disable=R0903
    """The arg spec for the vyos_bgp_address_family module"""

    argument_spec = {
        "config": {
            "type": "dict",
            "options": {
                "as_number": {"type": "int"},
                "address_family": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "afi": {"type": "str", "choices": ["ipv4", "ipv6"]},
                        "aggregate_address": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "prefix": {"type": "str"},
                                "as_set": {"type": "bool"},
                                "summary_only": {"type": "bool"},
                            },
                        },
                        "networks": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "prefix": {"type": "str"},
                                "path_limit": {"type": "int"},
                                "backdoor": {"type": "bool"},
                                "route_map": {"type": "str"},
                            },
                        },
                        "redistribute": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "protocol": {
                                    "type": "str",
                                    "choices": [
                                        "connected",
                                        "kernel",
                                        "ospf",
                                        "ospfv3",
                                        "rip",
                                        "ripng",
                                        "static",
                                    ],
                                },
                                "table": {"type": "str"},
                                "route_map": {"type": "str"},
                                "metric": {"type": "int"},
                            },
                        },
                    },
                },
                "neighbors": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "neighbor_address": {"type": "str"},
                        "address_family": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "afi": {
                                    "type": "str",
                                    "choices": ["ipv4", "ipv6"],
                                },
                                "allowas_in": {"type": "int"},
                                "as_override": {"type": "bool"},
                                "attribute_unchanged": {
                                    "type": "dict",
                                    "options": {
                                        "as_path": {"type": "bool"},
                                        "med": {"type": "bool"},
                                        "next_hop": {"type": "bool"},
                                    },
                                },
                                "capability": {
                                    "type": "dict",
                                    "options": {
                                        "dynamic": {"type": "bool"},
                                        "orf": {
                                            "type": "str",
                                            "choices": ["send", "receive"],
                                        },
                                    },
                                },
                                "default_originate": {"type": "str"},
                                "distribute_list": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "action": {
                                            "type": "str",
                                            "choices": ["export", "import"],
                                        },
                                        "acl": {"type": "int"},
                                    },
                                },
                                "filter_list": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "action": {
                                            "type": "str",
                                            "choices": ["export", "import"],
                                        },
                                        "path_list": {"type": "str"},
                                    },
                                },
                                "maximum_prefix": {"type": "int"},
                                "nexthop_local": {"type": "bool"},
                                "nexthop_self": {"type": "bool"},
                                "peer_group": {"type": "str"},
                                "prefix_list": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "action": {
                                            "type": "str",
                                            "choices": ["export", "import"],
                                        },
                                        "prefix_list": {"type": "str"},
                                    },
                                },
                                "remove_private_as": {"type": "bool"},
                                "route_map": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "action": {
                                            "type": "str",
                                            "choices": ["export", "import"],
                                        },
                                        "route_map": {"type": "str"},
                                    },
                                },
                                "route_reflector_client": {"type": "bool"},
                                "route_server_client": {"type": "bool"},
                                "soft_reconfiguration": {"type": "bool"},
                                "unsupress_map": {"type": "str"},
                                "weight": {"type": "int"},
                            },
                        },
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "type": "str",
            "choices": [
                "merged",
                "replaced",
                "deleted",
                "gathered",
                "parsed",
                "rendered",
                "purged",
                "overridden",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
