#!/bin/sh

OLDDIR=$(pwd)

if ! [ -f ./tool/ventoy_lib.sh ]; then
    if [ -f ${0%Ventoy2Disk.sh}/tool/ventoy_lib.sh ]; then
        cd ${0%Ventoy2Disk.sh}    
    fi
fi

if [ -f ./ventoy/version ]; then
    curver=$(cat ./ventoy/version) 
fi

if uname -m | grep -E -q 'aarch64|arm64'; then
    export TOOLDIR=aarch64
elif uname -m | grep -E -q 'x86_64|amd64'; then
    export TOOLDIR=x86_64
elif uname -m | grep -E -q 'mips64'; then
    export TOOLDIR=mips64el
else
    export TOOLDIR=i386
fi
export PATH="$OLDDIR/tool/$TOOLDIR:$PATH"


echo ''
echo '**********************************************'
echo "      Ventoy: $curver  $TOOLDIR"
echo "      longpanda admin@ventoy.net"
echo "      https://www.ventoy.net"
echo '**********************************************'
echo ''


./tool/VentoyWorker.sh $*
