/**
 * ./src/components/welcome.tsx
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import fs from 'fs';
import { Box, Newline, Text } from 'ink';
import yaml from 'js-yaml';
// pjson
import { createRequire } from 'module';
import React from 'react';
import Steps from './steps.js';
import Title from './title.js';
const require = createRequire(import.meta.url);
const pjson = require('../../../package.json');
export default function Welcome({ language = '' }) {
    let productName = 'unknown';
    let configRoot = '/etc/penguins-eggs.d/krill/';
    let version = 'unknown';
    if (fs.existsSync('/etc/calamares/settings.conf')) {
        configRoot = '/etc/calamares/';
    }
    const settings = yaml.load(fs.readFileSync(configRoot + 'settings.conf', 'utf8'));
    const { branding } = settings;
    const calamares = yaml.load(fs.readFileSync(configRoot + 'branding/' + branding + '/branding.desc', 'utf8'));
    productName = calamares.strings.productName;
    version = calamares.strings.version;
    /**
     * totale width=75
     * step width=15
     * finestra with=59
     */
    return (React.createElement(React.Fragment, null,
        React.createElement(Title, null),
        React.createElement(Box, { borderStyle: "round", flexDirection: "column", height: 11, width: 75 },
            React.createElement(Box, { flexDirection: "column" },
                React.createElement(Box, { flexDirection: "row" },
                    React.createElement(Steps, { step: 1 }),
                    React.createElement(Box, { flexDirection: "column" },
                        React.createElement(Text, null,
                            "Welcome to ",
                            pjson.name,
                            " system installer"),
                        React.createElement(Newline, null),
                        React.createElement(Text, null, "We are installing "),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Linux "),
                            React.createElement(Text, { color: "cyan" },
                                productName,
                                " "),
                            React.createElement(Text, null, "version "),
                            React.createElement(Text, { color: "cyan" }, version),
                            React.createElement(Text, null, " on "),
                            React.createElement(Text, { color: "cyan" }, process.arch)),
                        React.createElement(Box, { flexDirection: "column" },
                            React.createElement(Newline, null),
                            React.createElement(Text, null,
                                "Language: ",
                                language,
                                " "))))))));
}
