/*
 * Copyright (C) Ascensio System SIA 2012-2026. All rights reserved
 *
 * https://www.onlyoffice.com/
 *
 * Version: 9.3.0 (build:140)
 */

var g_version="0.0.0-0";var pathnameParts=self.location.pathname.split("/");if(pathnameParts.length>1&&pathnameParts[pathnameParts.length-2])g_version=pathnameParts[pathnameParts.length-2];var g_cacheNamePrefix="document_editor_static_";var g_cacheName=g_cacheNamePrefix+g_version;var g_cacheablePrefixes=["web-apps/","sdkjs/","fonts/","sdkjs-plugins/","dictionaries/"];var isDesktopEditor=navigator.userAgent.indexOf("AscDesktopEditor")!==-1;var g_storageInfoCache=null;var g_storageInfoCacheTime=0;
var STORAGE_INFO_CACHE_DURATION=3E4;var g_fifoCachePrefix="document_editor_dynamic_";var g_fifoCacheName=g_fifoCachePrefix+g_version;var g_fifoPrefix="cache/files/data/";var g_fifoDocIdParams=["shardkey","WOPISrc"];var g_fifoCacheTimeHeader="X-Cache-Time";var g_fifoConfig={maxDocIds:3,maxEntrySize:500*1024*1024,docIdTTL:10*60*1E3};
function fifoExtractDocId(url){if(url.indexOf("/"+g_fifoPrefix)===-1)return null;var queryIdx=url.indexOf("?");if(queryIdx===-1)return null;var queryString=url.substring(queryIdx+1);var params=queryString.split("&");var i=0;for(;i<params.length;i++){var pair=params[i].split("=");if(pair[1]&&g_fifoDocIdParams.indexOf(pair[0])!==-1)return decodeURIComponent(pair[1])}return null}
function fifoGetOldestTimestamp(keys,cache){if(!keys||keys.length===0)return Promise.resolve(0);return cache.match(keys[0]).then(function(response){if(!response)return 0;var timeStr=response.headers.get(g_fifoCacheTimeHeader);return timeStr?parseInt(timeStr,10):0}).catch(function(){return 0})}
function fifoAddTimestamp(response){var headers=new Headers(response.headers);headers.set(g_fifoCacheTimeHeader,Date.now().toString());return new Response(response.body,{status:response.status,statusText:response.statusText,headers:headers})}
function fifoCacheFile(request,docid,response){return caches.open(g_fifoCacheName).then(function(cache){return cache.keys().then(function(keys){var docidOrder=[];var docidKeys={};var i=0;for(;i<keys.length;i++){var keyDocid=fifoExtractDocId(keys[i].url);if(keyDocid){if(!docidKeys[keyDocid]){docidKeys[keyDocid]=[];docidOrder.push(keyDocid)}docidKeys[keyDocid].push(keys[i])}}return fifoGetOldestTimestamp(docidKeys[docid],cache).then(function(oldestTime){var isExpired=oldestTime>0&&Date.now()-oldestTime>
g_fifoConfig.docIdTTL;var evictions=[];if(docidKeys[docid]&&isExpired){var expiredKeys=docidKeys[docid];var j=0;for(;j<expiredKeys.length;j++)evictions.push(cache.delete(expiredKeys[j]));var idx=docidOrder.indexOf(docid);if(idx!==-1)docidOrder.splice(idx,1);delete docidKeys[docid]}if(!docidKeys[docid]&&docidOrder.length>=g_fifoConfig.maxDocIds){var oldestDocid=docidOrder[0];var oldestKeys=docidKeys[oldestDocid];var k=0;for(;k<oldestKeys.length;k++)evictions.push(cache.delete(oldestKeys[k]))}return Promise.all(evictions).then(function(){var timestampedResponse=
fifoAddTimestamp(response);return cache.put(request,timestampedResponse)})})})}).catch(function(err){console.error("fifoCacheFile failed:",err)})}function fifoGetFromCache(request){return caches.open(g_fifoCacheName).then(function(cache){return cache.match(request)}).catch(function(){return undefined})}function shouldUseFifoCache(url){return url.indexOf("/"+g_fifoPrefix)!==-1}
function safeToCache(request,response){return request.method==="GET"&&response&&response.ok&&(response.type==="basic"||response.type==="cors")&&!response.redirected}
function getStorageInfo(){var now=Date.now();if(g_storageInfoCache!==null&&now-g_storageInfoCacheTime<STORAGE_INFO_CACHE_DURATION)return Promise.resolve(g_storageInfoCache);if(!navigator.storage||!navigator.storage.estimate){g_storageInfoCache={maxEntrySize:50*1024*1024,isHealthy:true};g_storageInfoCacheTime=now;return Promise.resolve(g_storageInfoCache)}return navigator.storage.estimate().then(function(estimate){if(!estimate||typeof estimate.quota!=="number"||!isFinite(estimate.quota)||estimate.quota<=
0||typeof estimate.usage!=="number"||!isFinite(estimate.usage)){g_storageInfoCache={maxEntrySize:50*1024*1024,isHealthy:true};g_storageInfoCacheTime=Date.now();return g_storageInfoCache}var cacheSize=Math.min(estimate.quota*.1,1024*1024*1024);var maxEntrySize=cacheSize/8;var usageRatio=estimate.usage/estimate.quota;var isHealthy=usageRatio<.8;g_storageInfoCache={maxEntrySize:maxEntrySize,isHealthy:isHealthy};g_storageInfoCacheTime=Date.now();return g_storageInfoCache}).catch(function(error){g_storageInfoCache=
{maxEntrySize:50*1024*1024,isHealthy:true};g_storageInfoCacheTime=Date.now();return g_storageInfoCache})}
function putInCache(request,response,attempt){if(typeof attempt==="undefined")attempt=0;return caches.open(g_cacheName).then(function(cache){return cache.put(request,response.clone())}).catch(function(err){if(attempt<2)return(new Promise(function(resolve){setTimeout(resolve,250*Math.pow(2,attempt))})).then(function(){return putInCache(request,response,attempt+1)});else{var size=response.headers?response.headers.get("content-length"):"unknown";console.error("putInCache failed after max retries:",{url:request.url,
method:request.method,responseSize:size,responseType:response.type,cacheName:g_cacheName,error:err&&(err.message||err)})}})}
function cacheFirst(event){var request=event.request;var url=request.url;var fifoDocId=fifoExtractDocId(url);var cachePromise=fifoDocId?fifoGetFromCache(request):caches.match(request,{cacheName:g_cacheName});return cachePromise.then(function(cached){return cached||fetch(request).then(function(networkResp){var responseForCache=networkResp.clone();if(safeToCache(request,networkResp))event.waitUntil(getStorageInfo().then(function(info){if(!info.isHealthy)return;var size=Number(networkResp.headers.get("content-length"))||
0;if(fifoDocId){if(size===0||size<=g_fifoConfig.maxEntrySize)return fifoCacheFile(request,fifoDocId,responseForCache)}else if(size===0||size<info.maxEntrySize)return putInCache(request,responseForCache)}));return networkResp})})}
function activateWorker(event){return self.clients.claim().then(function(){return caches.keys()}).then(function(keys){var deletePromises=keys.filter(function(cache){var isOldStatic=cache.startsWith(g_cacheNamePrefix)&&cache!==g_cacheName;var isOldDynamic=cache.startsWith(g_fifoCachePrefix)&&cache!==g_fifoCacheName;return isOldStatic||isOldDynamic}).map(function(cache){return caches.delete(cache)});return Promise.all(deletePromises)}).catch(function(err){console.error("activateWorker failed with "+
err)})}function matchesCacheablePath(url){var g_versionNeedle="/"+g_version+"/";var versionIndex=url.indexOf(g_versionNeedle);if(versionIndex===-1)return false;var i=versionIndex+g_versionNeedle.length;var k=0;for(;k<g_cacheablePrefixes.length;k++)if(url.startsWith(g_cacheablePrefixes[k],i))return true;return false}self.addEventListener("install",function(event){event.waitUntil(self.skipWaiting())});self.addEventListener("activate",function(event){event.waitUntil(activateWorker())});
self.addEventListener("fetch",function(event){var request=event.request;var url=request.url;if(request.method!=="GET")return;var isCacheablePath=matchesCacheablePath(url);var isFifoPath=shouldUseFifoCache(url);if(!isCacheablePath&&!isFifoPath)return;if(isDesktopEditor&&url.indexOf("/sdkjs/common/AllFonts.js")!==-1)return;event.respondWith(cacheFirst(event))});
