---
myst:
  html_meta:
    keywords: LaTeX, programmation, syntaxe, TeX, longueur d'un mot, longueur d'une phrase, 
              longueur d'un texte, largeur d'un caractère
---

# Comment mesurer la largeur d'un caractère, d'un mot ou d'une phrase ?

## Avec TeX

Mettez le mot dans une boîte, puis mesurez simplement la largeur de la boîte. Par exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \pagestyle{empty}         % N'affiche pas de numéro de page

\newdimen\stringwidth
\setbox0=\hbox{Bonjour}
\stringwidth=\wd0

\begin{document}
<<\,Bonjour\,>> mesure \the\stringwidth.
\end{document}
```

Notez que si le contenu de la `\hbox` est une phrase, on n'obtiendra que sa longueur "naturelle",
c'est-à-dire sans les ajustements des espaces inter-mots qui se produisent normalement 
quand la phrase est insérée dans un paragraphe. 
Il faut considérer que la mesure obtenue est une approximation de la longueur réelle.


## Avec LaTeX

Dans ce cas, on utilisera plutôt la commande `\settowidth` :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page

\begin{document}
\newlength{\gnat}
\settowidth{\gnat}{\textbf{Bonjour}}
 
\textbf{Bonjour} \rule{\gnat}{2ex}
\end{document}
```

Cet exemple donne à la variable de longueur `\gnat` la valeur de la largeur 
du mot "Bonjour" écrit en gras.

:::{sources}
[Finding the width of a letter, word, or phrase](faquk:FAQ-findwidth)
:::