
#------------------------------------------------------------------------
function(smtg_private_setup_audiounit_sdk)
	if("${SMTG_AUDIOUNIT_SDK_PATH}" STREQUAL "")
		# Check if the AudioUnit SDK is next to the vst3sdk folder:
		set(AUDIOUNIT_SDK_PATH ${CMAKE_CURRENT_FUNCTION_LIST_DIR}/../../../AudioUnitSDK)
		if(NOT EXISTS "${AUDIOUNIT_SDK_PATH}/AudioUnitSDK.xcodeproj")
			# Check if the AudioUnit SDK is in the vst3sdk folder:
			set(AUDIOUNIT_SDK_PATH ${CMAKE_CURRENT_FUNCTION_LIST_DIR}/../../external.apple.audiounitsdk)
			if(NOT EXISTS "${AUDIOUNIT_SDK_PATH}/AudioUnitSDK.xcodeproj")
				set(AUDIOUNIT_SDK_PATH "")
			endif()
		endif()
		if(NOT "${AUDIOUNIT_SDK_PATH}" STREQUAL "")
			get_filename_component(AUDIOUNIT_SDK_PATH "${AUDIOUNIT_SDK_PATH}" ABSOLUTE)
		endif()
		set(SMTG_AUDIOUNIT_SDK_PATH "${AUDIOUNIT_SDK_PATH}" CACHE PATH "Path to the AudioUnit SDK" FORCE)
	elseif(NOT "${SMTG_AUDIOUNIT_SDK_PATH}" STREQUAL "")
		set(AUDIOUNIT_SDK_PATH "${SMTG_AUDIOUNIT_SDK_PATH}")
		if(NOT IS_ABSOLUTE ${AUDIOUNIT_SDK_PATH})
			get_filename_component(AUDIOUNIT_SDK_PATH "${CMAKE_CURRENT_FUNCTION_LIST_DIR}/../../${AUDIOUNIT_SDK_PATH}" ABSOLUTE)
		endif()
		if(NOT EXISTS "${AUDIOUNIT_SDK_PATH}/AudioUnitSDK.xcodeproj")
			message(FATAL_ERROR "[SMTG] SMTG_AUDIOUNIT_SDK_PATH is set but does not point to an expected location!")
		else()
			set(SMTG_AUDIOUNIT_SDK_PATH "${AUDIOUNIT_SDK_PATH}" CACHE PATH "Path to the AudioUnit SDK" FORCE)
		endif()
	endif()
	if(EXISTS "${SMTG_AUDIOUNIT_SDK_PATH}")
		message(STATUS "[SMTG] SMTG_AUDIOUNIT_SDK_PATH is set to: " ${SMTG_AUDIOUNIT_SDK_PATH})
		option(SMTG_ENABLE_AUV2_BUILDS "Enable AUv2 Builds" ON)
	endif()
endfunction(smtg_private_setup_audiounit_sdk)

#------------------------------------------------------------------------
function(smtg_private_setup_coreaudio_sdk)
	if("${SMTG_COREAUDIO_SDK_PATH}" STREQUAL "")
		# Check if the CoreAudio SDK is next to the vst3sdk folder:
		set(COREAUDIO_SDK_PATH ${CMAKE_CURRENT_FUNCTION_LIST_DIR}/../../../CoreAudio)
		if(NOT EXISTS "${COREAUDIO_SDK_PATH}/AudioUnits/AUPublic/AUBase/AUBase.cpp")
			# Check if the CoreAudio SDK is in the vst3sdk folder:
			set(COREAUDIO_SDK_PATH ${CMAKE_CURRENT_FUNCTION_LIST_DIR}/../../external.apple.coreaudio)
			if(NOT EXISTS "${COREAUDIO_SDK_PATH}/AudioUnits/AUPublic/AUBase/AUBase.cpp")
				set(COREAUDIO_SDK_PATH "")
			endif()
		endif()
		if(NOT "${COREAUDIO_SDK_PATH}" STREQUAL "")
			get_filename_component(COREAUDIO_SDK_PATH "${COREAUDIO_SDK_PATH}" ABSOLUTE)
		endif()
		set(SMTG_COREAUDIO_SDK_PATH "${COREAUDIO_SDK_PATH}" CACHE PATH "Here you can define where to find the COREAUDIO SDK" FORCE)
	else()
		set(COREAUDIO_SDK_PATH "${SMTG_COREAUDIO_SDK_PATH}")
		if(NOT IS_ABSOLUTE ${COREAUDIO_SDK_PATH})
			get_filename_component(COREAUDIO_SDK_PATH "${CMAKE_CURRENT_FUNCTION_LIST_DIR}/../../${COREAUDIO_SDK_PATH}" ABSOLUTE)
		endif()
		if(NOT EXISTS "${COREAUDIO_SDK_PATH}/AudioUnits/AUPublic/AUBase/AUBase.cpp")
			message(FATAL_ERROR "[SMTG] SMTG_COREAUDIO_SDK_PATH is set but does not point to an expected location!")
		else()
			set(SMTG_COREAUDIO_SDK_PATH "${COREAUDIO_SDK_PATH}" CACHE PATH "Here you can define where to find the COREAUDIO SDK" FORCE)
		endif()
	endif()
	if(EXISTS "${SMTG_COREAUDIO_SDK_PATH}")
		message(STATUS "[SMTG] SMTG_COREAUDIO_SDK_PATH is set to: " ${SMTG_COREAUDIO_SDK_PATH})
		option(SMTG_ENABLE_AUV2_BUILDS "Enable AUv2 Builds" ON)
	endif()

endfunction(smtg_private_setup_coreaudio_sdk)

#------------------------------------------------------------------------
function(setupCoreAudioSupport)
    if(SMTG_MAC AND XCODE)
        set(SMTG_IOS_DEVELOPMENT_TEAM "" CACHE STRING "Needed for building the InterAppAudio and AUv3 examples for iOS")

		smtg_private_setup_audiounit_sdk()
		if(NOT SMTG_ENABLE_AUV2_BUILDS)
			smtg_private_setup_coreaudio_sdk()
		endif()
        if("${SMTG_AUDIOUNIT_SDK_PATH}" STREQUAL "" AND "${SMTG_COREAUDIO_SDK_PATH}" STREQUAL "")
            message(STATUS "[SMTG] Neither SMTG_AUDIOUNIT_SDK_PATH nor SMTG_COREAUDIO_SDK_PATH is set. This is needed to build AudioUnit Version 2 plug-ins.")
        endif()
    endif()
endfunction(setupCoreAudioSupport)
