# SPDX-License-Identifier: GPL-2.0-only
# Copyright (C) 2025 John B. Wyatt IV
""" Module to return cpus and nics """

import os
import tuna.new_eth as ethtool

# Collect a few globals and functions so they can be reused in other modules
nr_cpus = None
nics = None

def get_nr_cpus():
    """ Get all cpus including disabled cpus """
    global nr_cpus
    if nr_cpus is not None:
        return nr_cpus
    nr_cpus = os.sysconf('SC_NPROCESSORS_CONF')
    return nr_cpus

def get_all_cpu_list():
    """ Return a list of all cpus """
    return list(range(get_nr_cpus()))

def get_nics():
    """ Return a list of network devices """
    global nics
    if nics is not None:
        return nics
    nics = ethtool.get_active_devices()
    return nics
