
# 11 "plugins/ring/g_ring.mlg"
 

open Ltac_plugin
open Pp
open Util
open Ring_ast
open Ring
open Stdarg
open Tacarg
open Procq.Constr
open Pltac


# 17 "plugins/ring/g_ring.ml"

let _ = Mltop.add_known_module "rocq-runtime.plugins.ring"
let () = Tacentries.tactic_extend "rocq-runtime.plugins.ring" "protect_fv" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("protect_fv", Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_string), 
                                                              Tacentries.TyIdent ("in", 
                                                              Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_ident), 
                                                              Tacentries.TyNil)))), 
           (fun map id ist -> 
# 29 "plugins/ring/g_ring.mlg"
      protect_tac_in map id 
# 30 "plugins/ring/g_ring.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("protect_fv", Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_string), 
                                                             Tacentries.TyNil)), 
          (fun map ist -> 
# 31 "plugins/ring/g_ring.mlg"
      protect_tac map 
# 38 "plugins/ring/g_ring.ml"
)))]


# 34 "plugins/ring/g_ring.mlg"
 

open Pptactic
open Ppconstr

let pr_ring_mod env sigma = function
  | Ring_kind (Computational eq_test) -> str "decidable" ++ pr_arg (pr_constr_expr env sigma) eq_test
  | Ring_kind Abstract ->  str "abstract"
  | Ring_kind (Morphism morph) -> str "morphism" ++ pr_arg (pr_constr_expr env sigma) morph
  | Const_tac (CstTac cst_tac) -> str "constants" ++ spc () ++ str "[" ++ pr_raw_tactic env sigma cst_tac ++ str "]"
  | Const_tac (Closed l) -> str "closed" ++ spc () ++ str "[" ++ prlist_with_sep spc pr_qualid l ++ str "]"
  | Pre_tac t -> str "preprocess" ++ spc () ++ str "[" ++ pr_raw_tactic env sigma t ++ str "]"
  | Post_tac t -> str "postprocess" ++ spc () ++ str "[" ++ pr_raw_tactic env sigma t ++ str "]"
  | Setoid(sth,ext) -> str "setoid" ++ pr_arg (pr_constr_expr env sigma) sth ++ pr_arg (pr_constr_expr env sigma) ext
  | Pow_spec(Closed l,spec) -> str "power_tac" ++ pr_arg (pr_constr_expr env sigma) spec ++ spc () ++ str "[" ++ prlist_with_sep spc pr_qualid l ++ str "]"
  | Pow_spec(CstTac cst_tac,spec) -> str "power_tac" ++ pr_arg (pr_constr_expr env sigma) spec ++ spc () ++ str "[" ++ pr_raw_tactic env sigma cst_tac ++ str "]"
  | Sign_spec t -> str "sign" ++ pr_arg (pr_constr_expr env sigma) t
  | Div_spec t -> str "div" ++ pr_arg (pr_constr_expr env sigma) t


# 63 "plugins/ring/g_ring.ml"

let (wit_ring_mod, ring_mod) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ring") ~name:"ring_mod" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next
        (Procq.Rule.next (Procq.Rule.stop)
         ((Procq.Symbol.token (Procq.terminal "div"))))
        ((Procq.Symbol.nterm constr)))
       (fun div_spec _ loc -> 
# 70 "plugins/ring/g_ring.mlg"
                                    Div_spec div_spec 
# 78 "plugins/ring/g_ring.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next
          (Procq.Rule.next (Procq.Rule.stop)
           ((Procq.Symbol.token (Procq.terminal "power_tac"))))
          ((Procq.Symbol.nterm constr)))
         ((Procq.Symbol.token (Procq.terminal "["))))
        ((Procq.Symbol.nterm tactic)))
       ((Procq.Symbol.token (Procq.terminal "]"))))
      (fun _ cst_tac _ pow_spec _ loc -> 
# 69 "plugins/ring/g_ring.mlg"
             Pow_spec (CstTac cst_tac, pow_spec) 
# 94 "plugins/ring/g_ring.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next
          (Procq.Rule.next (Procq.Rule.stop)
           ((Procq.Symbol.token (Procq.terminal "power"))))
          ((Procq.Symbol.nterm constr)))
         ((Procq.Symbol.token (Procq.terminal "["))))
        ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
       ((Procq.Symbol.token (Procq.terminal "]"))))
      (fun _ l _ pow_spec _ loc -> 
# 67 "plugins/ring/g_ring.mlg"
             Pow_spec (Closed l, pow_spec) 
# 110 "plugins/ring/g_ring.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next (Procq.Rule.stop)
        ((Procq.Symbol.token (Procq.terminal "sign"))))
       ((Procq.Symbol.nterm constr)))
      (fun sign_spec _ loc -> 
# 65 "plugins/ring/g_ring.mlg"
                                      Sign_spec sign_spec 
# 120 "plugins/ring/g_ring.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next
        (Procq.Rule.next (Procq.Rule.stop)
         ((Procq.Symbol.token (Procq.terminal "setoid"))))
        ((Procq.Symbol.nterm constr)))
       ((Procq.Symbol.nterm constr)))
      (fun ext sth _ loc -> 
# 64 "plugins/ring/g_ring.mlg"
                                              Setoid(sth,ext) 
# 132 "plugins/ring/g_ring.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next (Procq.Rule.stop)
          ((Procq.Symbol.token (Procq.terminal "postprocess"))))
         ((Procq.Symbol.token (Procq.terminal "["))))
        ((Procq.Symbol.nterm tactic)))
       ((Procq.Symbol.token (Procq.terminal "]"))))
      (fun _ post _ _ loc -> 
# 63 "plugins/ring/g_ring.mlg"
                                                Post_tac post 
# 146 "plugins/ring/g_ring.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next (Procq.Rule.stop)
          ((Procq.Symbol.token (Procq.terminal "preprocess"))))
         ((Procq.Symbol.token (Procq.terminal "["))))
        ((Procq.Symbol.nterm tactic)))
       ((Procq.Symbol.token (Procq.terminal "]"))))
      (fun _ pre _ _ loc -> 
# 62 "plugins/ring/g_ring.mlg"
                                              Pre_tac pre 
# 160 "plugins/ring/g_ring.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next (Procq.Rule.stop)
          ((Procq.Symbol.token (Procq.terminal "closed"))))
         ((Procq.Symbol.token (Procq.terminal "["))))
        ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
       ((Procq.Symbol.token (Procq.terminal "]"))))
      (fun _ l _ _ loc -> 
# 61 "plugins/ring/g_ring.mlg"
                                                Const_tac(Closed l) 
# 174 "plugins/ring/g_ring.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next (Procq.Rule.stop)
          ((Procq.Symbol.token (Procq.terminal "constants"))))
         ((Procq.Symbol.token (Procq.terminal "["))))
        ((Procq.Symbol.nterm tactic)))
       ((Procq.Symbol.token (Procq.terminal "]"))))
      (fun _ cst_tac _ _ loc -> 
# 60 "plugins/ring/g_ring.mlg"
                                                 Const_tac(CstTac cst_tac) 
# 188 "plugins/ring/g_ring.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next (Procq.Rule.stop)
        ((Procq.Symbol.token (Procq.terminal "morphism"))))
       ((Procq.Symbol.nterm constr)))
      (fun morph _ loc -> 
# 59 "plugins/ring/g_ring.mlg"
                                      Ring_kind(Morphism morph) 
# 198 "plugins/ring/g_ring.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop)
       ((Procq.Symbol.token (Procq.terminal "abstract"))))
      (fun _ loc -> 
# 58 "plugins/ring/g_ring.mlg"
                        Ring_kind Abstract 
# 206 "plugins/ring/g_ring.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next (Procq.Rule.stop)
        ((Procq.Symbol.token (Procq.terminal "decidable"))))
       ((Procq.Symbol.nterm constr)))
      (fun eq_test _ loc -> 
# 57 "plugins/ring/g_ring.mlg"
                                         Ring_kind(Computational eq_test) 
# 216 "plugins/ring/g_ring.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 56 "plugins/ring/g_ring.mlg"
               pr_ring_mod env sigma 
# 221 "plugins/ring/g_ring.ml"
;
    }
let _ = (wit_ring_mod, ring_mod)


# 73 "plugins/ring/g_ring.mlg"
 

let pr_ring_mods env sigma l = surround (prlist_with_sep pr_comma (pr_ring_mod env sigma) l)


# 233 "plugins/ring/g_ring.ml"

let (wit_ring_mods, ring_mods) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ring") ~name:"ring_mods" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next (Procq.Rule.stop)
          ((Procq.Symbol.token (Procq.terminal "("))))
         ((Procq.Symbol.list1sep ((Procq.Symbol.nterm ring_mod)) ((Procq.Symbol.rules 
         [Procq.Rules.make (Procq.Rule.next_norec (Procq.Rule.stop)
                            ((Procq.Symbol.token (Procq.terminal ","))))
                           (fun _ loc -> ())])) false)))
        ((Procq.Symbol.token (Procq.terminal ")"))))
       (fun _ mods _ loc -> 
# 81 "plugins/ring/g_ring.mlg"
                                                     mods 
# 253 "plugins/ring/g_ring.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 80 "plugins/ring/g_ring.mlg"
               pr_ring_mods env sigma 
# 258 "plugins/ring/g_ring.ml"
;
    }
let _ = (wit_ring_mods, ring_mods)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ring") ~command:"AddSetoidRing" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Ring",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
            Vernacextend.TyTerminal
            (":",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
             Vernacextend.TyNonTerminal (Extend.TUopt (Extend.TUentry (Genarg.get_arg_tag wit_ring_mods)),
             Vernacextend.TyNil)))))),
          (let coqpp_body id t l () = Vernactypes.vtdefault (fun () -> 
# 86 "plugins/ring/g_ring.mlg"
      add_theory id.CAst.v t (Option.default [] l) 
# 279 "plugins/ring/g_ring.ml"
) in
            fun id t l ?loc ~atts () ->
            coqpp_body id t l (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Print", Vernacextend.TyTerminal ("Rings", Vernacextend.TyNil)),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 87 "plugins/ring/g_ring.mlg"
                                                                  
    print_rings ()
  
# 293 "plugins/ring/g_ring.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          Some (fun ~atts -> 
# 87 "plugins/ring/g_ring.mlg"
                             Vernacextend.classify_as_query 
# 300 "plugins/ring/g_ring.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ring" "ring_lookup" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("ring_lookup", Tacentries.TyArg (
                                                               Extend.TUentryl (Genarg.get_arg_tag wit_tactic, 0), 
                                                               Tacentries.TyIdent ("[", 
                                                               Tacentries.TyArg (
                                                               Extend.TUlist0 (
                                                               Extend.TUentry (Genarg.get_arg_tag wit_constr)), 
                                                               Tacentries.TyIdent ("]", 
                                                               Tacentries.TyArg (
                                                               Extend.TUlist1 (
                                                               Extend.TUentry (Genarg.get_arg_tag wit_constr)), 
                                                               Tacentries.TyNil)))))), 
           (fun f lH lrt ist -> 
# 94 "plugins/ring/g_ring.mlg"
      let (t,lr) = List.sep_last lrt in ring_lookup f lH lr t 
# 318 "plugins/ring/g_ring.ml"
)))]


# 97 "plugins/ring/g_ring.mlg"
 

let pr_field_mod env sigma = function
  | Ring_mod m -> pr_ring_mod env sigma m
  | Inject inj -> str "completeness" ++ pr_arg (pr_constr_expr env sigma) inj


# 330 "plugins/ring/g_ring.ml"

let (wit_field_mod, field_mod) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ring") ~name:"field_mod" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next
        (Procq.Rule.next (Procq.Rule.stop)
         ((Procq.Symbol.token (Procq.terminal "completeness"))))
        ((Procq.Symbol.nterm constr)))
       (fun inj _ loc -> 
# 108 "plugins/ring/g_ring.mlg"
                                        Inject inj 
# 345 "plugins/ring/g_ring.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop) ((Procq.Symbol.nterm ring_mod)))
      (fun m loc -> 
# 107 "plugins/ring/g_ring.mlg"
                         Ring_mod m 
# 352 "plugins/ring/g_ring.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 106 "plugins/ring/g_ring.mlg"
               pr_field_mod env sigma 
# 357 "plugins/ring/g_ring.ml"
;
    }
let _ = (wit_field_mod, field_mod)


# 111 "plugins/ring/g_ring.mlg"
 

let pr_field_mods env sigma l = surround (prlist_with_sep pr_comma (pr_field_mod env sigma) l)


# 369 "plugins/ring/g_ring.ml"

let (wit_field_mods, field_mods) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ring") ~name:"field_mods" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next (Procq.Rule.stop)
          ((Procq.Symbol.token (Procq.terminal "("))))
         ((Procq.Symbol.list1sep ((Procq.Symbol.nterm field_mod)) ((Procq.Symbol.rules 
         [Procq.Rules.make (Procq.Rule.next_norec (Procq.Rule.stop)
                            ((Procq.Symbol.token (Procq.terminal ","))))
                           (fun _ loc -> ())])) false)))
        ((Procq.Symbol.token (Procq.terminal ")"))))
       (fun _ mods _ loc -> 
# 119 "plugins/ring/g_ring.mlg"
                                                      mods 
# 389 "plugins/ring/g_ring.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 118 "plugins/ring/g_ring.mlg"
               pr_field_mods env sigma 
# 394 "plugins/ring/g_ring.ml"
;
    }
let _ = (wit_field_mods, field_mods)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ring") ~command:"AddSetoidField" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Field",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
            Vernacextend.TyTerminal
            (":",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
             Vernacextend.TyNonTerminal (Extend.TUopt (Extend.TUentry (Genarg.get_arg_tag wit_field_mods)),
             Vernacextend.TyNil)))))),
          (let coqpp_body id t l () = Vernactypes.vtdefault (fun () -> 
# 124 "plugins/ring/g_ring.mlg"
    let l = match l with None -> [] | Some l -> l in add_field_theory id.CAst.v t l 
# 415 "plugins/ring/g_ring.ml"
) in
            fun id t l ?loc ~atts () ->
            coqpp_body id t l (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Print", Vernacextend.TyTerminal ("Fields", Vernacextend.TyNil)),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 125 "plugins/ring/g_ring.mlg"
                                                               
    print_fields ()
  
# 429 "plugins/ring/g_ring.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          Some (fun ~atts -> 
# 125 "plugins/ring/g_ring.mlg"
                           Vernacextend.classify_as_query
# 436 "plugins/ring/g_ring.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ring" "field_lookup" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("field_lookup", Tacentries.TyArg (
                                                                Extend.TUentry (Genarg.get_arg_tag wit_tactic), 
                                                                Tacentries.TyIdent ("[", 
                                                                Tacentries.TyArg (
                                                                Extend.TUlist0 (
                                                                Extend.TUentry (Genarg.get_arg_tag wit_constr)), 
                                                                Tacentries.TyIdent ("]", 
                                                                Tacentries.TyArg (
                                                                Extend.TUlist1 (
                                                                Extend.TUentry (Genarg.get_arg_tag wit_constr)), 
                                                                Tacentries.TyNil)))))), 
           (fun f lH lt ist -> 
# 132 "plugins/ring/g_ring.mlg"
        let (t,l) = List.sep_last lt in field_lookup f lH l t 
# 454 "plugins/ring/g_ring.ml"
)))]

