# This file has been autogenerated by the pywayland scanner

# Copyright © 2021-2023 Andri Yngvason
# Copyright © 2024 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..ext_image_capture_source_v1 import ExtImageCaptureSourceV1
from ..wayland import WlPointer
from .ext_image_copy_capture_cursor_session_v1 import ExtImageCopyCaptureCursorSessionV1
from .ext_image_copy_capture_session_v1 import ExtImageCopyCaptureSessionV1


class ExtImageCopyCaptureManagerV1(Interface):
    """Manager to inform clients and begin capturing

    This object is a manager which offers requests to start capturing from a
    source.
    """

    name = "ext_image_copy_capture_manager_v1"
    version = 1

    class error(enum.IntEnum):
        invalid_option = 1

    class options(enum.IntFlag):
        paint_cursors = 1


class ExtImageCopyCaptureManagerV1Proxy(Proxy[ExtImageCopyCaptureManagerV1]):
    interface = ExtImageCopyCaptureManagerV1

    @ExtImageCopyCaptureManagerV1.request(
        Argument(ArgumentType.NewId, interface=ExtImageCopyCaptureSessionV1),
        Argument(ArgumentType.Object, interface=ExtImageCaptureSourceV1),
        Argument(ArgumentType.Uint),
    )
    def create_session(self, source: ExtImageCaptureSourceV1, options: int) -> Proxy[ExtImageCopyCaptureSessionV1]:
        """Capture an image capture source

        Create a capturing session for an image capture source.

        If the paint_cursors option is set, cursors shall be composited onto
        the captured frame. The cursor must not be composited onto the frame if
        this flag is not set.

        If the options bitfield is invalid, the invalid_option protocol error
        is sent.

        :param source:
        :type source:
            :class:`~pywayland.protocol.ext_image_capture_source_v1.ExtImageCaptureSourceV1`
        :param options:
        :type options:
            `ArgumentType.Uint`
        :returns:
            :class:`~pywayland.protocol.ext_image_copy_capture_v1.ExtImageCopyCaptureSessionV1`
        """
        session = self._marshal_constructor(0, ExtImageCopyCaptureSessionV1, source, options)
        return session

    @ExtImageCopyCaptureManagerV1.request(
        Argument(ArgumentType.NewId, interface=ExtImageCopyCaptureCursorSessionV1),
        Argument(ArgumentType.Object, interface=ExtImageCaptureSourceV1),
        Argument(ArgumentType.Object, interface=WlPointer),
    )
    def create_pointer_cursor_session(self, source: ExtImageCaptureSourceV1, pointer: WlPointer) -> Proxy[ExtImageCopyCaptureCursorSessionV1]:
        """Capture the pointer cursor of an image capture source

        Create a cursor capturing session for the pointer of an image capture
        source.

        :param source:
        :type source:
            :class:`~pywayland.protocol.ext_image_capture_source_v1.ExtImageCaptureSourceV1`
        :param pointer:
        :type pointer:
            :class:`~pywayland.protocol.wayland.WlPointer`
        :returns:
            :class:`~pywayland.protocol.ext_image_copy_capture_v1.ExtImageCopyCaptureCursorSessionV1`
        """
        session = self._marshal_constructor(1, ExtImageCopyCaptureCursorSessionV1, source, pointer)
        return session

    @ExtImageCopyCaptureManagerV1.request()
    def destroy(self) -> None:
        """Destroy the manager

        Destroy the manager object.

        Other objects created via this interface are unaffected.
        """
        self._marshal(2)
        self._destroy()


class ExtImageCopyCaptureManagerV1Resource(Resource):
    interface = ExtImageCopyCaptureManagerV1


class ExtImageCopyCaptureManagerV1Global(Global):
    interface = ExtImageCopyCaptureManagerV1


ExtImageCopyCaptureManagerV1._gen_c()
ExtImageCopyCaptureManagerV1.proxy_class = ExtImageCopyCaptureManagerV1Proxy
ExtImageCopyCaptureManagerV1.resource_class = ExtImageCopyCaptureManagerV1Resource
ExtImageCopyCaptureManagerV1.global_class = ExtImageCopyCaptureManagerV1Global
