/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

final class MultiLogRecordProcessor
implements LogRecordProcessor {
    private final List<LogRecordProcessor> logRecordProcessors;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    static LogRecordProcessor create(List<LogRecordProcessor> logRecordProcessorsList) {
        return new MultiLogRecordProcessor(new ArrayList<LogRecordProcessor>((Collection)Objects.requireNonNull(logRecordProcessorsList, "logRecordProcessorsList")));
    }

    @Override
    public void onEmit(Context context, ReadWriteLogRecord logRecord) {
        for (LogRecordProcessor logRecordProcessor : this.logRecordProcessors) {
            logRecordProcessor.onEmit(context, logRecord);
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>(this.logRecordProcessors.size());
        for (LogRecordProcessor logRecordProcessor : this.logRecordProcessors) {
            results.add(logRecordProcessor.shutdown());
        }
        return CompletableResultCode.ofAll(results);
    }

    @Override
    public CompletableResultCode forceFlush() {
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>(this.logRecordProcessors.size());
        for (LogRecordProcessor logRecordProcessor : this.logRecordProcessors) {
            results.add(logRecordProcessor.forceFlush());
        }
        return CompletableResultCode.ofAll(results);
    }

    private MultiLogRecordProcessor(List<LogRecordProcessor> logRecordProcessorsList) {
        this.logRecordProcessors = logRecordProcessorsList;
    }
}

