/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.defaults;

import com.jetbrains.fus.reporting.FusHttpClient;
import com.jetbrains.fus.reporting.FusJsonSerializer;
import com.jetbrains.fus.reporting.FusReportDispatcher;
import com.jetbrains.fus.reporting.RemoteConfig;
import com.jetbrains.fus.reporting.model.lion4.FusReport;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/fus/reporting/defaults/DefaultReportDispatcher;", "Lcom/jetbrains/fus/reporting/FusReportDispatcher;", "remoteConfig", "Lcom/jetbrains/fus/reporting/RemoteConfig;", "jsonSerializer", "Lcom/jetbrains/fus/reporting/FusJsonSerializer;", "httpClient", "Lcom/jetbrains/fus/reporting/FusHttpClient;", "(Lcom/jetbrains/fus/reporting/RemoteConfig;Lcom/jetbrains/fus/reporting/FusJsonSerializer;Lcom/jetbrains/fus/reporting/FusHttpClient;)V", "getHttpClient", "()Lcom/jetbrains/fus/reporting/FusHttpClient;", "getJsonSerializer", "()Lcom/jetbrains/fus/reporting/FusJsonSerializer;", "getRemoteConfig", "()Lcom/jetbrains/fus/reporting/RemoteConfig;", "dispatchReport", "", "report", "Lcom/jetbrains/fus/reporting/model/lion4/FusReport;", "api-jvm-defaults"})
public final class DefaultReportDispatcher
implements FusReportDispatcher {
    @NotNull
    private final RemoteConfig remoteConfig;
    @NotNull
    private final FusJsonSerializer jsonSerializer;
    @NotNull
    private final FusHttpClient httpClient;

    public DefaultReportDispatcher(@NotNull RemoteConfig remoteConfig, @NotNull FusJsonSerializer jsonSerializer, @NotNull FusHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)remoteConfig, (String)"remoteConfig");
        Intrinsics.checkNotNullParameter((Object)jsonSerializer, (String)"jsonSerializer");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.remoteConfig = remoteConfig;
        this.jsonSerializer = jsonSerializer;
        this.httpClient = httpClient;
    }

    @NotNull
    public final RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    @NotNull
    public final FusJsonSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    @NotNull
    public final FusHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public void dispatchReport(@NotNull FusReport report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        String reportJson = this.jsonSerializer.toJson(report);
        this.httpClient.post(this.remoteConfig.getSendUrl(), reportJson);
    }
}

