/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.dictionary.Dictionary;
import com.intellij.internal.statistic.eventLog.validator.DictionaryStorage;
import com.intellij.internal.statistic.eventLog.validator.IEventContext;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import java.io.FileNotFoundException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/DictionaryValidationRule;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/PerformanceCareRule;", "dictionaryName", "", "dictionaryStorage", "Lcom/intellij/internal/statistic/eventLog/validator/DictionaryStorage;", "(Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/validator/DictionaryStorage;)V", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/IEventContext;", "toString", "ap-validation"})
public final class DictionaryValidationRule
extends PerformanceCareRule {
    @NotNull
    private final String dictionaryName;
    @Nullable
    private final DictionaryStorage dictionaryStorage;

    public DictionaryValidationRule(@NotNull String dictionaryName, @Nullable DictionaryStorage dictionaryStorage) {
        Intrinsics.checkNotNullParameter((Object)dictionaryName, (String)"dictionaryName");
        this.dictionaryName = dictionaryName;
        this.dictionaryStorage = dictionaryStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected ValidationResultType doValidate(@NotNull String data, @NotNull IEventContext context) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.dictionaryStorage == null) {
            return ValidationResultType.DICTIONARY_NOT_FOUND;
        }
        DictionaryStorage dictionaryStorage = this.dictionaryStorage;
        synchronized (dictionaryStorage) {
            ValidationResultType validationResultType;
            boolean bl = false;
            try {
                Dictionary dictionary = this.dictionaryStorage.getDictionaryByName(this.dictionaryName);
                validationResultType = dictionary.contains(data) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
            }
            catch (FileNotFoundException fileNotFoundException) {
                validationResultType = ValidationResultType.DICTIONARY_NOT_FOUND;
            }
            catch (Exception exception) {
                validationResultType = ValidationResultType.GENERAL_DICTIONARY_ERROR;
            }
            ValidationResultType validationResultType2 = validationResultType;
            return validationResultType2;
        }
    }

    @NotNull
    public String toString() {
        return "DictionaryValidationRule: dictionary=" + this.dictionaryName;
    }
}

