/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.stereo.Stereotype;

public class ChartSeries {
    private final String name;
    private final SeriesType type;
    private final List<Double> values;
    private final List<Double> xValues;
    private HColor color;
    private boolean useSecondaryAxis;
    private boolean showLabels;
    private MarkerShape markerShape;
    private Stereotype stereotype;

    public ChartSeries(String name, SeriesType type, List<Double> values) {
        this.name = name;
        this.type = type;
        this.values = new ArrayList<Double>(values);
        this.xValues = null;
        this.useSecondaryAxis = false;
        this.showLabels = false;
        this.markerShape = MarkerShape.CIRCLE;
    }

    public ChartSeries(String name, SeriesType type, List<Double> xValues, List<Double> yValues) {
        this.name = name;
        this.type = type;
        this.xValues = new ArrayList<Double>(xValues);
        this.values = new ArrayList<Double>(yValues);
        this.useSecondaryAxis = false;
        this.showLabels = false;
        this.markerShape = MarkerShape.CIRCLE;
    }

    public String getName() {
        return this.name;
    }

    public SeriesType getType() {
        return this.type;
    }

    public List<Double> getValues() {
        return this.values;
    }

    public List<Double> getXValues() {
        return this.xValues;
    }

    public boolean hasExplicitXValues() {
        return this.xValues != null;
    }

    public HColor getColor() {
        return this.color;
    }

    public void setColor(HColor color) {
        this.color = color;
    }

    public boolean isUseSecondaryAxis() {
        return this.useSecondaryAxis;
    }

    public void setUseSecondaryAxis(boolean useSecondaryAxis) {
        this.useSecondaryAxis = useSecondaryAxis;
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public MarkerShape getMarkerShape() {
        return this.markerShape;
    }

    public void setMarkerShape(MarkerShape markerShape) {
        this.markerShape = markerShape;
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    public static enum SeriesType {
        BAR,
        LINE,
        AREA,
        SCATTER;

    }

    public static enum MarkerShape {
        CIRCLE,
        SQUARE,
        TRIANGLE;

    }
}

