/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.cryptacular.CryptUtil;
import org.cryptacular.codec.Base64Decoder;
import org.cryptacular.codec.Decoder;
import org.cryptacular.codec.HexDecoder;

public class DecodingInputStream
extends FilterInputStream {
    private final Decoder decoder;
    private final InputStreamReader reader;
    private CharBuffer input;
    private ByteBuffer output;

    public DecodingInputStream(InputStream in, Decoder d) {
        super(CryptUtil.assertNotNullArg(in, "Input stream cannot be null"));
        this.decoder = CryptUtil.assertNotNullArg(d, "Decoder cannot be null");
        this.reader = new InputStreamReader(in);
    }

    @Override
    public int read() throws IOException {
        return this.read(new byte[1]);
    }

    @Override
    public int read(byte[] b) throws IOException {
        CryptUtil.assertNotNullArg(b, "Input byte array cannot be null");
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        CryptUtil.assertNotNullArg(b, "Input byte array cannot be null");
        this.prepareInputBuffer(len - off);
        this.prepareOutputBuffer();
        if (this.reader.read(this.input) < 0) {
            this.decoder.finalize(this.output);
            if (this.output.position() == 0) {
                return -1;
            }
        } else {
            this.input.flip();
            this.decoder.decode(this.input, this.output);
        }
        this.output.flip();
        this.output.get(b, off, this.output.limit());
        return this.output.position();
    }

    public static DecodingInputStream base64(InputStream in) {
        return new DecodingInputStream(in, new Base64Decoder());
    }

    public static DecodingInputStream hex(InputStream in) {
        return new DecodingInputStream(in, new HexDecoder());
    }

    private void prepareInputBuffer(int required) {
        if (this.input == null || this.input.capacity() < required) {
            this.input = CharBuffer.allocate(required);
        } else {
            this.input.clear();
        }
    }

    private void prepareOutputBuffer() {
        int required = this.decoder.outputSize(this.input.capacity());
        if (this.output == null || this.output.capacity() < required) {
            this.output = ByteBuffer.allocate(required);
        } else {
            this.output.clear();
        }
    }
}

