/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.ensemble;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import org.tribuo.Example;
import org.tribuo.Excuse;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.provenance.EnsembleModelProvenance;
import org.tribuo.provenance.ModelProvenance;

public abstract class EnsembleModel<T extends Output<T>>
extends Model<T> {
    private static final long serialVersionUID = 1L;
    protected final List<Model<T>> models;

    protected EnsembleModel(String name, EnsembleModelProvenance provenance, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo, List<Model<T>> newModels) {
        super(name, provenance, featureIDMap, outputIDInfo, true);
        this.models = Collections.unmodifiableList(newModels);
    }

    public List<Model<T>> getModels() {
        return this.models;
    }

    public int getNumModels() {
        return this.models.size();
    }

    @Override
    public abstract Optional<Excuse<T>> getExcuse(Example<T> var1);

    @Override
    public EnsembleModelProvenance getProvenance() {
        return (EnsembleModelProvenance)this.provenance;
    }

    @Override
    protected Model<T> copy(String name, ModelProvenance newProvenance) {
        return this.copy(name, (EnsembleModelProvenance)newProvenance, new ArrayList<Model<T>>(this.models));
    }

    protected abstract EnsembleModel<T> copy(String var1, EnsembleModelProvenance var2, List<Model<T>> var3);

    @Override
    public Map<String, List<Pair<String, Double>>> getTopFeatures(int n) {
        HashMap<String, Map> featureMap = new HashMap<String, Map>();
        for (Model<T> model : this.models) {
            Map<String, List<Pair<String, Double>>> scoredFeatures = model.getTopFeatures(n);
            for (Map.Entry<String, List<Object>> entry : scoredFeatures.entrySet()) {
                Map curSet = featureMap.computeIfAbsent(entry.getKey(), k -> new HashMap());
                for (Pair pair : entry.getValue()) {
                    Pair tmp = new Pair(pair.getA(), (Object)((Double)pair.getB() / (double)this.models.size()));
                    curSet.merge(tmp.getA(), tmp, (p1, p2) -> new Pair(p1.getA(), (Object)((Double)p1.getB() + (Double)p2.getB())));
                }
            }
        }
        int maxFeatures = n < 0 ? this.featureIDMap.size() : n;
        Comparator<Pair> comparator = Comparator.comparingDouble(p -> Math.abs((Double)p.getB()));
        HashMap<String, List<Pair<String, Double>>> map = new HashMap<String, List<Pair<String, Double>>>();
        for (Map.Entry<String, List<Object>> entry : featureMap.entrySet()) {
            PriorityQueue<Pair> q = new PriorityQueue<Pair>(maxFeatures, comparator);
            for (Pair pair : ((Map)((Object)entry.getValue())).values()) {
                if (q.size() < maxFeatures) {
                    q.offer(pair);
                    continue;
                }
                if (comparator.compare(pair, q.peek()) <= 0) continue;
                q.poll();
                q.offer(pair);
            }
            ArrayList<Pair> list = new ArrayList<Pair>();
            while (q.size() > 0) {
                list.add(q.poll());
            }
            Collections.reverse(list);
            map.put(entry.getKey(), list);
        }
        return map;
    }
}

