/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.jni;

import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.jni.PlatformUtils;

public class KNNLibraryLoader {
    @Generated
    private static final Logger log = LogManager.getLogger(KNNLibraryLoader.class);
    protected static Set<String> loaded = new HashSet<String>();
    static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibrary(String name) {
        Object object = lock;
        synchronized (object) {
            if (loaded.contains(name)) {
                log.info("Library already loaded: {}", (Object)name);
                return;
            }
            try {
                AccessController.doPrivileged(() -> {
                    System.loadLibrary(name);
                    return null;
                });
                loaded.add(name);
            }
            catch (UnsatisfiedLinkError e) {
                log.error("Failed to load library: {}", (Object)name);
                throw e;
            }
            log.info("Loaded library: {}", (Object)name);
        }
    }

    static void loadFaissLibrary() {
        if (!KNNSettings.isFaissAVX512SPRDisabled() && PlatformUtils.isAVX512SPRSupportedBySystem()) {
            KNNLibraryLoader.loadLibrary("opensearchknn_faiss_avx512_spr");
        } else if (!KNNSettings.isFaissAVX512Disabled() && PlatformUtils.isAVX512SupportedBySystem()) {
            KNNLibraryLoader.loadLibrary("opensearchknn_faiss_avx512");
        } else if (!KNNSettings.isFaissAVX2Disabled() && PlatformUtils.isAVX2SupportedBySystem()) {
            KNNLibraryLoader.loadLibrary("opensearchknn_faiss_avx2");
        } else {
            KNNLibraryLoader.loadLibrary("opensearchknn_faiss");
        }
    }

    static void loadNmslibLibrary() {
        KNNLibraryLoader.loadLibrary("opensearchknn_nmslib");
    }

    static void loadCommonLibrary() {
        KNNLibraryLoader.loadLibrary("opensearchknn_common");
    }

    static void loadSimdLibrary() {
        if (!KNNSettings.isFaissAVX512SPRDisabled() && PlatformUtils.isAVX512SPRSupportedBySystem()) {
            KNNLibraryLoader.loadLibrary("opensearchknn_simd_avx512_spr");
        } else if (!KNNSettings.isFaissAVX512Disabled() && PlatformUtils.isAVX512SupportedBySystem()) {
            KNNLibraryLoader.loadLibrary("opensearchknn_simd_avx512");
        } else if (!KNNSettings.isFaissAVX2Disabled() && PlatformUtils.isAVX2SupportedBySystem()) {
            KNNLibraryLoader.loadLibrary("opensearchknn_simd_avx2");
        } else {
            KNNLibraryLoader.loadLibrary("opensearchknn_simd");
        }
    }
}

