"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEventAnalyticsRouter = void 0;
var _configSchema = require("@osd/config-schema");
var _shared = require("../../../common/constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const registerEventAnalyticsRouter = ({
  router,
  savedObjectFacet
}) => {
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}`,
    validate: {}
  }, async (context, req, res) => {
    var _savedRes$data, _savedRes$data2;
    const savedRes = await savedObjectFacet.getSavedObject(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success || (savedRes === null || savedRes === void 0 || (_savedRes$data = savedRes.data) === null || _savedRes$data === void 0 ? void 0 : _savedRes$data.statusCode) === 404) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data2 = savedRes.data) === null || _savedRes$data2 === void 0 ? void 0 : _savedRes$data2.statusCode) || 400;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/{objectId}`,
    validate: {
      params: _configSchema.schema.object({
        objectId: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data3, _savedRes$data4;
    const savedRes = await savedObjectFacet.getSavedObjectById(req, req.params.objectId);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success || (savedRes === null || savedRes === void 0 || (_savedRes$data3 = savedRes.data) === null || _savedRes$data3 === void 0 ? void 0 : _savedRes$data3.statusCode) === 404) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data4 = savedRes.data) === null || _savedRes$data4 === void 0 ? void 0 : _savedRes$data4.statusCode) || 400;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_QUERY}`,
    validate: {
      body: _configSchema.schema.object({
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data5;
    const savedRes = await savedObjectFacet.createSavedQuery(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data5 = savedRes.data) === null || _savedRes$data5 === void 0 ? void 0 : _savedRes$data5.statusCode) || 400;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_VISUALIZATION}`,
    validate: {
      body: _configSchema.schema.object({
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          type: _configSchema.schema.string(),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string(),
          application_id: _configSchema.schema.maybe(_configSchema.schema.string()),
          userConfigs: _configSchema.schema.maybe(_configSchema.schema.string()),
          subType: _configSchema.schema.maybe(_configSchema.schema.string()),
          metricType: _configSchema.schema.maybe(_configSchema.schema.string()),
          units_of_measure: _configSchema.schema.maybe(_configSchema.schema.string()),
          selected_labels: _configSchema.schema.maybe(_configSchema.schema.object({
            label: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))
          }))
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data6;
    const savedRes = await savedObjectFacet.createSavedVisualization(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data6 = savedRes.data) === null || _savedRes$data6 === void 0 ? void 0 : _savedRes$data6.statusCode) || 400;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_QUERY}`,
    validate: {
      body: _configSchema.schema.object({
        object_id: _configSchema.schema.string(),
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data7;
    const savedRes = await savedObjectFacet.updateSavedQuery(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data7 = savedRes.data) === null || _savedRes$data7 === void 0 ? void 0 : _savedRes$data7.statusCode) || 400;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_VISUALIZATION}`,
    validate: {
      body: _configSchema.schema.object({
        object_id: _configSchema.schema.string(),
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          type: _configSchema.schema.string(),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string(),
          application_id: _configSchema.schema.maybe(_configSchema.schema.string()),
          userConfigs: _configSchema.schema.maybe(_configSchema.schema.string()),
          subType: _configSchema.schema.maybe(_configSchema.schema.string()),
          metricType: _configSchema.schema.maybe(_configSchema.schema.string()),
          units_of_measure: _configSchema.schema.maybe(_configSchema.schema.string()),
          selected_labels: _configSchema.schema.maybe(_configSchema.schema.object({
            labels: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))
          }))
        })
      })
    }
  }, async (context, req, res) => {
    var _updateRes$data;
    const updateRes = await savedObjectFacet.updateSavedVisualization(req);
    const result = {
      body: {
        ...updateRes.data
      }
    };
    if (updateRes.success) return res.ok(result);
    result.statusCode = (updateRes === null || updateRes === void 0 || (_updateRes$data = updateRes.data) === null || _updateRes$data === void 0 ? void 0 : _updateRes$data.statusCode) || 400;
    result.message = (updateRes === null || updateRes === void 0 ? void 0 : updateRes.data) || '';
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/timestamp`,
    validate: {
      body: _configSchema.schema.object({
        name: _configSchema.schema.string(),
        index: _configSchema.schema.string(),
        type: _configSchema.schema.string(),
        dsl_type: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data8;
    const savedRes = await savedObjectFacet.createSavedTimestamp(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data8 = savedRes.data) === null || _savedRes$data8 === void 0 ? void 0 : _savedRes$data8.statusCode) || 400;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/timestamp`,
    validate: {
      body: _configSchema.schema.object({
        objectId: _configSchema.schema.string(),
        timestamp: _configSchema.schema.object({
          name: _configSchema.schema.string(),
          index: _configSchema.schema.string(),
          type: _configSchema.schema.string(),
          dsl_type: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data9;
    const savedRes = await savedObjectFacet.updateSavedTimestamp(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data9 = savedRes.data) === null || _savedRes$data9 === void 0 ? void 0 : _savedRes$data9.statusCode) || 400;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.delete({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/{objectIdList}`,
    validate: {
      params: _configSchema.schema.object({
        objectIdList: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _deleteResponse$data;
    const deleteResponse = await savedObjectFacet.deleteSavedObject(req);
    const result = {
      body: {
        ...deleteResponse.data
      }
    };
    if (deleteResponse.success) return res.ok(result);
    result.statusCode = (deleteResponse === null || deleteResponse === void 0 || (_deleteResponse$data = deleteResponse.data) === null || _deleteResponse$data === void 0 ? void 0 : _deleteResponse$data.statusCode) || 400;
    result.message = (deleteResponse === null || deleteResponse === void 0 ? void 0 : deleteResponse.data) || '';
    return res.custom(result);
  });
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/addSampleSavedObjects/{sampleRequestor}`,
    validate: {
      params: _configSchema.schema.object({
        sampleRequestor: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data10;
    const savedRes = await savedObjectFacet.createSampleSavedObjects(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data10 = savedRes.data) === null || _savedRes$data10 === void 0 ? void 0 : _savedRes$data10.statusCode) || 400;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
};
exports.registerEventAnalyticsRouter = registerEventAnalyticsRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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