/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.breaker;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.timeseries.breaker.BreakerName;
import org.opensearch.timeseries.breaker.CircuitBreaker;
import org.opensearch.timeseries.breaker.MemoryCircuitBreaker;
import org.opensearch.timeseries.settings.TimeSeriesEnabledSetting;

public class CircuitBreakerService {
    private final ConcurrentMap<String, CircuitBreaker> breakers = new ConcurrentHashMap<String, CircuitBreaker>();
    private final JvmService jvmService;
    private static final Logger logger = LogManager.getLogger(CircuitBreakerService.class);

    public CircuitBreakerService(JvmService jvmService) {
        this.jvmService = jvmService;
    }

    public void registerBreaker(String name, CircuitBreaker breaker) {
        this.breakers.putIfAbsent(name, breaker);
    }

    public void unregisterBreaker(String name) {
        if (name == null) {
            return;
        }
        this.breakers.remove(name);
    }

    public void clearBreakers() {
        this.breakers.clear();
    }

    public CircuitBreaker getBreaker(String name) {
        return (CircuitBreaker)this.breakers.get(name);
    }

    public CircuitBreakerService init() {
        this.registerBreaker(BreakerName.MEM.getName(), new MemoryCircuitBreaker(this.jvmService));
        logger.info("Registered memory breaker.");
        return this;
    }

    public Boolean isOpen() {
        if (!TimeSeriesEnabledSetting.isBreakerEnabled()) {
            return false;
        }
        for (CircuitBreaker breaker : this.breakers.values()) {
            if (!breaker.isOpen()) continue;
            return true;
        }
        return false;
    }
}

