/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.collections.JoinedList;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.DiscriminatorHelper;

public final class SingleTableSubclass
extends Subclass {
    public SingleTableSubclass(PersistentClass superclass, MetadataBuildingContext buildingContext) {
        super(superclass, buildingContext);
    }

    @Override
    protected List<Property> getNonDuplicatedProperties() {
        return new JoinedList<Property>(this.getSuperclass().getUnjoinedProperties(), this.getUnjoinedProperties());
    }

    @Override
    public Object accept(PersistentClassVisitor mv) {
        return mv.accept(this);
    }

    @Override
    public void validate(Metadata mapping) throws MappingException {
        if (this.getDiscriminator() == null) {
            throw new MappingException("No discriminator defined by '" + this.getSuperclass().getEntityName() + "' which is a root class in a 'SINGLE_TABLE' inheritance hierarchy");
        }
        super.validate(mapping);
    }

    @Override
    public void createConstraints(MetadataBuildingContext context) {
        Value discriminator;
        List<Selectable> selectables;
        Dialect dialect;
        if (!this.isAbstract().booleanValue() && (dialect = context.getMetadataCollector().getDatabase().getDialect()).supportsTableCheck() && (selectables = (discriminator = this.getDiscriminator()).getSelectables()).size() == 1) {
            StringBuilder check = new StringBuilder();
            check.append(selectables.get(0).getText(dialect));
            if (this.isDiscriminatorValueNull()) {
                check.append(" is ");
            } else {
                if (this.isDiscriminatorValueNotNull()) {
                    check.append(" is ");
                    return;
                }
                check.append(" <> ");
            }
            check.append(DiscriminatorHelper.getDiscriminatorSQLValue(this, dialect)).append(" or (");
            boolean first = true;
            for (Property property : this.getNonDuplicatedProperties()) {
                if (property.isComposite() || property.isOptional()) continue;
                for (Selectable selectable : property.getSelectables()) {
                    Column column;
                    if (!(selectable instanceof Column) || !(column = (Column)selectable).isNullable()) continue;
                    if (first) {
                        first = false;
                    } else {
                        check.append(" and ");
                    }
                    check.append(column.getQuotedName(dialect)).append(" is not null");
                }
            }
            check.append(")");
            if (!first) {
                this.getTable().addCheck(new CheckConstraint(check.toString()));
            }
        }
    }
}

