/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.internal.stax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;
import org.hibernate.boot.xsd.XsdDescriptor;
import org.hibernate.boot.xsd.XsdHelper;

public abstract class AbstractEventReader
extends EventReaderDelegate {
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private final String rootElementName;
    private final XsdDescriptor xsdDescriptor;
    private final XMLEventFactory xmlEventFactory;

    public AbstractEventReader(String rootElementName, XsdDescriptor xsdDescriptor, XMLEventReader reader, XMLEventFactory xmlEventFactory) {
        super(reader);
        this.rootElementName = rootElementName;
        this.xsdDescriptor = xsdDescriptor;
        this.xmlEventFactory = xmlEventFactory;
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        return this.wrap(super.peek());
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        return this.wrap(super.nextEvent());
    }

    private XMLEvent wrap(XMLEvent event) {
        if (event != null) {
            if (event.isStartElement()) {
                return this.wrap(event.asStartElement());
            }
            if (event.isEndElement()) {
                return this.wrap(event.asEndElement());
            }
        }
        return event;
    }

    private StartElement wrap(StartElement startElement) {
        List<Attribute> newElementAttributeList = this.mapAttributes(startElement);
        List<Namespace> newNamespaceList = this.mapNamespaces(startElement);
        this.xmlEventFactory.setLocation(startElement.getLocation());
        return this.xmlEventFactory.createStartElement(new QName(this.xsdDescriptor.getNamespaceUri(), startElement.getName().getLocalPart()), newElementAttributeList.iterator(), newNamespaceList.iterator());
    }

    private Iterator<Attribute> existingXmlAttributesIterator(StartElement startElement) {
        return startElement.getAttributes();
    }

    private List<Attribute> mapAttributes(StartElement startElement) {
        ArrayList<Attribute> mappedAttributes = new ArrayList<Attribute>();
        Iterator<Attribute> existingAttributesIterator = this.existingXmlAttributesIterator(startElement);
        while (existingAttributesIterator.hasNext()) {
            Attribute originalAttribute = existingAttributesIterator.next();
            Attribute attributeToUse = this.mapAttribute(startElement, originalAttribute);
            mappedAttributes.add(attributeToUse);
        }
        return mappedAttributes;
    }

    private Attribute mapAttribute(StartElement startElement, Attribute originalAttribute) {
        if (this.rootElementName.equals(startElement.getName().getLocalPart()) && VERSION_ATTRIBUTE_NAME.equals(originalAttribute.getName().getLocalPart())) {
            String specifiedVersion = originalAttribute.getValue();
            if (!XsdHelper.isValidJpaVersion(specifiedVersion)) {
                throw new BadVersionException(specifiedVersion);
            }
            return this.xmlEventFactory.createAttribute(VERSION_ATTRIBUTE_NAME, this.xsdDescriptor.getVersion());
        }
        return originalAttribute;
    }

    private List<Namespace> mapNamespaces(StartElement startElement) {
        return this.mapNamespaces(this.existingXmlNamespacesIterator(startElement));
    }

    private List<Namespace> mapNamespaces(Iterator<Namespace> originalNamespaceIterator) {
        ArrayList<Namespace> mappedNamespaces = new ArrayList<Namespace>();
        while (originalNamespaceIterator.hasNext()) {
            Namespace originalNamespace = originalNamespaceIterator.next();
            Namespace mappedNamespace = this.mapNamespace(originalNamespace);
            mappedNamespaces.add(mappedNamespace);
        }
        if (mappedNamespaces.isEmpty()) {
            mappedNamespaces.add(this.xmlEventFactory.createNamespace(this.xsdDescriptor.getNamespaceUri()));
        }
        return mappedNamespaces;
    }

    private Iterator<Namespace> existingXmlNamespacesIterator(StartElement startElement) {
        return startElement.getNamespaces();
    }

    private Namespace mapNamespace(Namespace originalNamespace) {
        if (this.shouldBeMappedToLatestJpaDescriptor(originalNamespace.getNamespaceURI())) {
            return this.xmlEventFactory.createNamespace(originalNamespace.getPrefix(), this.xsdDescriptor.getNamespaceUri());
        }
        return originalNamespace;
    }

    protected abstract boolean shouldBeMappedToLatestJpaDescriptor(String var1);

    private XMLEvent wrap(EndElement endElement) {
        List<Namespace> targetNamespaces = this.mapNamespaces(this.existingXmlNamespacesIterator(endElement));
        this.xmlEventFactory.setLocation(endElement.getLocation());
        return this.xmlEventFactory.createEndElement(new QName(this.xsdDescriptor.getNamespaceUri(), endElement.getName().getLocalPart()), targetNamespaces.iterator());
    }

    private Iterator<Namespace> existingXmlNamespacesIterator(EndElement endElement) {
        return endElement.getNamespaces();
    }

    public static class BadVersionException
    extends RuntimeException {
        private final String requestedVersion;

        public BadVersionException(String requestedVersion) {
            this.requestedVersion = requestedVersion;
        }

        public String getRequestedVersion() {
            return this.requestedVersion;
        }
    }
}

