/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.function.Function;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.OffsetExpirationCondition;

public class OffsetExpirationConditionImpl
implements OffsetExpirationCondition {
    private final Function<OffsetAndMetadata, Long> baseTimestamp;

    public OffsetExpirationConditionImpl(Function<OffsetAndMetadata, Long> baseTimestamp) {
        this.baseTimestamp = baseTimestamp;
    }

    @Override
    public boolean isOffsetExpired(OffsetAndMetadata offset, long currentTimestampMs, long offsetsRetentionMs) {
        if (offset.expireTimestampMs.isPresent()) {
            return currentTimestampMs >= offset.expireTimestampMs.getAsLong();
        }
        return currentTimestampMs - this.baseTimestamp.apply(offset) >= offsetsRetentionMs;
    }

    public Function<OffsetAndMetadata, Long> baseTimestamp() {
        return this.baseTimestamp;
    }
}

